/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.base.block;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.blocks.base.block.BlockMultiTile;
import com.mordenkainen.equivalentenergistics.integration.ae2.NetworkLights;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.IAEProxyHost;
import com.mordenkainen.equivalentenergistics.integration.ae2.tiles.TileAEBase;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import com.mordenkainen.equivalentenergistics.util.IDropItems;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMultiAE
extends BlockMultiTile {
    public static final PropertyEnum<NetworkLights> LIGHTS = PropertyEnum.func_177709_a((String)"lights", NetworkLights.class);

    public BlockMultiAE(Material material, String name, int count) {
        super(material, name, count);
        this.multiBlockState = new BlockStateContainer((Block)this, new IProperty[]{this.type, LIGHTS});
        this.func_180632_j(this.multiBlockState.func_177621_b().func_177226_a(LIGHTS, (Comparable)((Object)NetworkLights.NONE)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(LIGHTS, (Comparable)((Object)NetworkLights.NONE));
    }

    @Override
    public void registerItemModel(Item itemBlock) {
        for (int i = 0; i < this.count; ++i) {
            EquivalentEnergistics.proxy.registerItemRenderer(itemBlock, i, this.name, "lights=none,type=" + i);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileAEBase tile = (TileAEBase)world.func_175625_s(pos);
        if (tile != null) {
            return state.func_177226_a(LIGHTS, (Comparable)((Object)(tile.isPowered() ? NetworkLights.POWERED : NetworkLights.NONE)));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IAEProxyHost tile = CommonUtils.getTE(IAEProxyHost.class, (IBlockAccess)world, pos);
        if (tile != null && placer instanceof EntityPlayer) {
            tile.setOwner((EntityPlayer)placer);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IDropItems tile;
        if (!world.field_72995_K && (tile = CommonUtils.getTE(IDropItems.class, (IBlockAccess)world, pos)) != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            tile.getDrops(world, pos, drops);
            for (ItemStack drop : drops) {
                CommonUtils.spawnEntItem(world, pos, drop);
            }
        }
        super.func_180663_b(world, pos, state);
    }
}

