/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.render;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import com.mordenkainen.equivalentenergistics.blocks.crafter.model.CrafterConnector;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.TileEMCCrafter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CrafterRenderer
extends TileEntitySpecialRenderer<TileEMCCrafter> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("equivalentenergistics:textures/models/emc_crafter_connector.png");
    private final CrafterConnector model = new CrafterConnector();

    public void render(TileEMCCrafter te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.isCableConnected(te.func_145831_w(), te.func_174877_v(), face)) continue;
            this.model.renderConnector(face);
        }
        GlStateManager.func_179121_F();
        NonNullList stacks = te.isCrafting() ? te.getDisplayStacks() : NonNullList.func_191197_a((int)1, (Object)te.getCurrentTome());
        if (stacks.size() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            float time = (float)Minecraft.func_71410_x().func_175606_aa().field_70173_aa + partialTicks;
            float anglePer = 360.0f / (float)stacks.size();
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = (ItemStack)stacks.get(i);
                if (stack.func_190926_b()) continue;
                GlStateManager.func_179094_E();
                if (stacks.size() > 1) {
                    GlStateManager.func_179137_b((double)0.5, (double)0.3, (double)0.5);
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179114_b((float)(anglePer * (float)i + time), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)0.2, (double)0.0, (double)0.25);
                } else {
                    GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
                }
                EntityItem entityitem = new EntityItem(te.func_145831_w(), 0.0, 0.0, 0.0, stack);
                GlStateManager.func_179114_b((float)(time % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                entityitem.field_70290_d = 0.0f;
                Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    private boolean isCableConnected(World world, BlockPos pos, EnumFacing face) {
        int tileYPos = pos.func_177956_o() + face.func_96559_d();
        if (tileYPos < 0 || tileYPos > 256) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos.func_177972_a(face));
        if (!(tile instanceof IGridHost) || !(tile instanceof IPartHost)) {
            return false;
        }
        IPartHost host = (IPartHost)tile;
        IPart part = host.getPart(AEPartLocation.INTERNAL);
        if (part instanceof IPartCable) {
            IPartCable cable = (IPartCable)part;
            return cable.isConnected(face.func_176734_d());
        }
        return false;
    }
}

