/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import com.mordenkainen.equivalentenergistics.blocks.ModBlocks;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.CraftingManager;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.ICraftingMonitor;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import com.mordenkainen.equivalentenergistics.integration.ae2.EMCCraftingPattern;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.ITransProvider;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.tiles.TileAEBase;
import com.mordenkainen.equivalentenergistics.integration.hwyla.IWailaNBTProvider;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import com.mordenkainen.equivalentenergistics.util.IDropItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEMCCrafter
extends TileAEBase
implements IGridTickable,
IDropItems,
ITransProvider,
ICraftingProvider,
ICraftingMonitor,
IWailaNBTProvider {
    private static final String TOME_TAG = "Tome";
    private static final String OWNER_TAG = "Owner";
    private static final String EMC_TAG = "CurrentEMC";
    private static final String CRAFTING_TAG = "Crafting";
    private static final String DISPLAY_TAG = "DisplayStacks";
    private static final String STACK_TAG = "Stack";
    private static final String ERROR_TAG = "Errored";
    private ItemStack transmutationItem = ItemStack.field_190927_a;
    private long currentEMC;
    private NonNullList<ItemStack> displayStacks;
    private final CraftingManager manager;
    private boolean crafting;
    private boolean errored;
    private boolean doDrops = true;

    public TileEMCCrafter() {
        this(1, EqEConfig.emcAssembler.craftingTime, 0);
    }

    public TileEMCCrafter(int jobs, double time, int meta) {
        super(new ItemStack(Item.func_150898_a((Block)ModBlocks.CRAFTER), 1, meta));
        this.gridProxy.setIdlePowerUsage(EqEConfig.emcAssembler.idlePower);
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.displayStacks = NonNullList.func_191197_a((int)jobs, (Object)ItemStack.field_190927_a);
        this.manager = new CraftingManager(time, jobs, this, this.getProxy(), this.mySource);
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        if (this.currentEMC > 0L) {
            tag.func_74772_a(EMC_TAG, this.currentEMC);
        }
        if (!this.transmutationItem.func_190926_b()) {
            tag.func_74778_a(OWNER_TAG, this.transmutationItem.func_77978_p().func_74779_i(OWNER_TAG));
        }
        return tag;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        if (!this.isActive()) {
            return TickRateModulation.IDLE;
        }
        this.injectEMC();
        if (this.manager.isCrafting()) {
            boolean newState;
            boolean bl = newState = !this.manager.craftingTick();
            if (newState != this.errored) {
                this.errored = newState;
                this.markForUpdate();
            }
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SAME;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.currentEMC = data.func_74763_f(EMC_TAG);
        this.transmutationItem = data.func_74764_b(TOME_TAG) ? new ItemStack((NBTTagCompound)data.func_74781_a(TOME_TAG)) : ItemStack.field_190927_a;
        this.manager.readFromNBT(data);
        this.displayStacks = this.manager.getCurrentJobs();
        this.markForUpdate();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        if (this.currentEMC > 0L) {
            data.func_74772_a(EMC_TAG, this.currentEMC);
        }
        if (this.transmutationItem != null) {
            data.func_74782_a(TOME_TAG, (NBTBase)this.transmutationItem.func_77955_b(new NBTTagCompound()));
        }
        this.manager.writeToNBT(data);
        return data;
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting invCrafting) {
        if (this.isActive() && patternDetails instanceof EMCCraftingPattern && this.manager.addJob(patternDetails.getOutputs()[0].createItemStack(), ((EMCCraftingPattern)patternDetails).outputEMC, EqEConfig.emcAssembler.powerPerEMC)) {
            this.currentEMC = (long)((double)this.currentEMC + (((EMCCraftingPattern)patternDetails).inputEMC - ((EMCCraftingPattern)patternDetails).outputEMC));
            this.displayStacks = this.manager.getCurrentJobs();
            this.markForUpdate();
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.manager.isBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingProvider) {
        GridUtils.addPatterns(this.getProxy(), (ICraftingMedium)this, craftingProvider);
    }

    public ItemStack getCurrentTome() {
        return this.transmutationItem;
    }

    public void setCurrentTome(ItemStack heldItem) {
        this.transmutationItem = heldItem;
        GridUtils.updatePatterns(this.getProxy());
        this.markForUpdate();
    }

    public boolean canPlayerInteract(EntityPlayer player) {
        return this.checkPermissions(player) && !this.manager.isCrafting();
    }

    private void injectEMC() {
        this.currentEMC -= GridUtils.injectEMC(this.getProxy(), this.currentEMC, Actionable.MODULATE, this.mySource);
    }

    @Override
    public void getDrops(World world, BlockPos pos, List<ItemStack> drops) {
        if (this.doDrops && !this.transmutationItem.func_190926_b()) {
            drops.add(this.transmutationItem);
        }
    }

    @Override
    public void disableDrops() {
        this.doDrops = false;
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        nbttagcompound.func_74757_a(CRAFTING_TAG, this.manager.isCrafting());
        nbttagcompound.func_74757_a(ERROR_TAG, this.errored);
        if (this.manager.isCrafting()) {
            NBTTagCompound displayTags = new NBTTagCompound();
            for (int i = 0; i < this.displayStacks.size(); ++i) {
                if (this.displayStacks.get(i) == null) continue;
                displayTags.func_74782_a(STACK_TAG + i, (NBTBase)((ItemStack)this.displayStacks.get(i)).func_77955_b(new NBTTagCompound()));
            }
            nbttagcompound.func_74782_a(DISPLAY_TAG, (NBTBase)displayTags);
        }
        if (this.transmutationItem != null) {
            nbttagcompound.func_74782_a(TOME_TAG, (NBTBase)this.transmutationItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        this.crafting = nbttagcompound.func_74767_n(CRAFTING_TAG);
        this.errored = nbttagcompound.func_74767_n(ERROR_TAG);
        if (nbttagcompound.func_74764_b(DISPLAY_TAG)) {
            NBTTagCompound invList = nbttagcompound.func_74775_l(DISPLAY_TAG);
            for (int i = 0; i < this.displayStacks.size(); ++i) {
                if (invList.func_74764_b(STACK_TAG + i)) {
                    this.displayStacks.set(i, (Object)new ItemStack(invList.func_74775_l(STACK_TAG + i)));
                    continue;
                }
                this.displayStacks.set(i, (Object)ItemStack.field_190927_a);
            }
        }
        this.transmutationItem = nbttagcompound.func_74764_b(TOME_TAG) ? new ItemStack(nbttagcompound.func_74775_l(TOME_TAG)) : ItemStack.field_190927_a;
        return super.readPacketData(nbttagcompound);
    }

    @Override
    public String getPlayerUUID() {
        return this.transmutationItem.func_190926_b() ? null : UUID.fromString(this.transmutationItem.func_77978_p().func_74779_i("OwnerUUID")).toString();
    }

    @Override
    public List<ItemStack> getTransmutations() {
        ArrayList<ItemStack> transmutations = new ArrayList<ItemStack>();
        if (!this.transmutationItem.func_190926_b()) {
            transmutations.addAll(ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(UUID.fromString(this.transmutationItem.func_77978_p().func_74779_i("OwnerUUID"))).getKnowledge());
            Iterator iter = transmutations.iterator();
            while (iter.hasNext()) {
                ItemStack currentItem = (ItemStack)iter.next();
                if (currentItem.func_77973_b() != ModItems.CRYSTAL) continue;
                iter.remove();
            }
        }
        return transmutations;
    }

    @Override
    public void craftingFinished(ItemStack outputStack) {
        this.displayStacks = this.manager.getCurrentJobs();
        this.markForUpdate();
    }

    public NonNullList<ItemStack> getDisplayStacks() {
        return this.displayStacks;
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public boolean isErrored() {
        return this.errored;
    }
}

