/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.mordenkainen.equivalentenergistics.integration.ae2.BaseActionSource;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.EMCStorageGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IAEEMCStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IEMCStorageChannel;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EMCCrystalHandler
implements ICellProvider,
IMEInventoryHandler<IAEItemStack> {
    private final EMCStorageGrid hostGrid;
    private final IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    private IItemList<IAEItemStack> cachedList = this.storageChannel.createList();
    private double last_value;

    public EMCCrystalHandler(EMCStorageGrid host) {
        this.hostGrid = host;
    }

    public IAEItemStack injectItems(IAEItemStack stack, Actionable mode, IActionSource src) {
        if (stack.getItem() == ModItems.CRYSTAL) {
            IEMCStorageChannel emcChannel = (IEMCStorageChannel)AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class);
            IStorageGrid storageGrid = (IStorageGrid)this.hostGrid.getGrid().getCache(IStorageGrid.class);
            IAEEMCStack rejected = (IAEEMCStack)storageGrid.getInventory((IStorageChannel)emcChannel).injectItems(emcChannel.createStack(stack.getStackSize() * ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]), Actionable.SIMULATE, src);
            double emcAdded = stack.getStackSize() * ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()] - (rejected == null ? 0L : rejected.getEMCValue());
            if (emcAdded < (double)ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]) {
                return stack;
            }
            long toAdd = (long)(emcAdded / (double)ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]);
            if (mode == Actionable.MODULATE) {
                storageGrid.getInventory((IStorageChannel)emcChannel).injectItems(emcChannel.createStack(toAdd * ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]), Actionable.MODULATE, src);
            }
            return toAdd == stack.getStackSize() ? null : (IAEItemStack)stack.copy().setStackSize(stack.getStackSize() - toAdd);
        }
        return stack;
    }

    public IAEItemStack extractItems(IAEItemStack stack, Actionable mode, IActionSource src) {
        if (stack.getItem() == ModItems.CRYSTAL) {
            IEMCStorageChannel emcChannel = (IEMCStorageChannel)AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class);
            IStorageGrid storageGrid = (IStorageGrid)this.hostGrid.getGrid().getCache(IStorageGrid.class);
            IAEEMCStack extracted = (IAEEMCStack)storageGrid.getInventory((IStorageChannel)emcChannel).extractItems(emcChannel.createStack(stack.getStackSize() * ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]), Actionable.SIMULATE, src);
            if (extracted == null || extracted.getEMCValue() < ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]) {
                return null;
            }
            long toRemove = extracted.getEMCValue() / ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()];
            if (mode == Actionable.MODULATE) {
                storageGrid.getInventory((IStorageChannel)emcChannel).extractItems(emcChannel.createStack(toRemove * ItemEMCCrystal.CRYSTAL_VALUES[stack.getItemDamage()]), mode, src);
            }
            return (IAEItemStack)stack.copy().setStackSize(toRemove);
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> items) {
        for (IAEItemStack stack : this.cachedList) {
            items.add((IAEStack)stack);
        }
        return items;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack stack) {
        return ModItems.CRYSTAL == stack.getItem();
    }

    public boolean canAccept(IAEItemStack stack) {
        return ModItems.CRYSTAL == stack.getItem();
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int pass) {
        return pass == 1;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (channel.equals((Object)this.storageChannel)) {
            return new ArrayList<IMEInventoryHandler>(Arrays.asList(this));
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public int getPriority() {
        return 0x7FFFFFFE;
    }

    public void updateDisplay() {
        IStorageGrid storageGrid = (IStorageGrid)this.hostGrid.getGrid().getCache(IStorageGrid.class);
        double currentEMC = this.getCurrentEMC();
        if (currentEMC != this.last_value) {
            this.last_value = currentEMC;
            for (IAEItemStack stack : this.cachedList) {
                stack.setStackSize(-stack.getStackSize());
            }
            storageGrid.postAlterationOfStoredItems((IStorageChannel)this.storageChannel, this.cachedList, (IActionSource)new BaseActionSource());
            this.cachedList = this.storageChannel.createList();
            if (currentEMC > 0.0) {
                for (int i = 4; i >= 0; --i) {
                    double crystalEMC = ItemEMCCrystal.CRYSTAL_VALUES[i];
                    long crystalcount = (long)(currentEMC / crystalEMC);
                    if (crystalcount <= 0L) continue;
                    this.cachedList.add(((IAEItemStack)this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.CRYSTAL, 1, i))).setStackSize(crystalcount));
                    currentEMC -= (double)crystalcount * crystalEMC;
                }
            }
            this.cachedList.add(((IAEItemStack)this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.MISC, 1, 1))).setStackSize((long)this.last_value));
            storageGrid.postAlterationOfStoredItems((IStorageChannel)this.storageChannel, this.cachedList, (IActionSource)new BaseActionSource());
        }
    }

    private double getCurrentEMC() {
        IEMCStorageChannel emcChannel = (IEMCStorageChannel)AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class);
        IStorageGrid storageGrid = (IStorageGrid)this.hostGrid.getGrid().getCache(IStorageGrid.class);
        IAEEMCStack emcStack = (IAEEMCStack)storageGrid.getInventory((IStorageChannel)emcChannel).getStorageList().findPrecise(emcChannel.createStack(1));
        return emcStack == null ? 0.0 : (double)emcStack.getEMCValue();
    }
}

