/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.grid;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.EMCCraftingPattern;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.IEMCCraftingGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.IEMCStorageGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.AEProxy;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridAccessException;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IAEEMCStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IEMCStorageChannel;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import net.minecraft.item.ItemStack;

public final class GridUtils {
    private static IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);

    private GridUtils() {
    }

    private static <T extends IGridCache> T getCache(Class<T> cacheType, AEProxy proxy) throws GridAccessException {
        IGrid grid = proxy.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        IGridCache cache = grid.getCache(cacheType);
        if (cache == null) {
            throw new GridAccessException();
        }
        return (T)cache;
    }

    public static IPathingGrid getPath(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(IPathingGrid.class, proxy);
    }

    public static IStorageGrid getStorage(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(IStorageGrid.class, proxy);
    }

    public static ISecurityGrid getSecurity(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(ISecurityGrid.class, proxy);
    }

    public static ICraftingGrid getCrafting(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(ICraftingGrid.class, proxy);
    }

    public static IEnergyGrid getEnergy(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(IEnergyGrid.class, proxy);
    }

    public static ITickManager getTick(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(ITickManager.class, proxy);
    }

    public static IEMCStorageGrid getEMCStorage(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(IEMCStorageGrid.class, proxy);
    }

    public static IEMCCraftingGrid getEMCCrafting(AEProxy proxy) throws GridAccessException {
        return GridUtils.getCache(IEMCCraftingGrid.class, proxy);
    }

    public static double getAEMaxEnergy(AEProxy proxy) {
        try {
            return GridUtils.getEnergy(proxy).getMaxStoredPower();
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:getAEMaxEnergy: Error accessing grid:", e);
            return 0.0;
        }
    }

    public static double getAECurrentEnergy(AEProxy proxy) {
        try {
            return GridUtils.getEnergy(proxy).getStoredPower();
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:getAECurrentEnergy: Error accessing grid:", e);
            return 0.0;
        }
    }

    public static double getAEDemand(AEProxy proxy, double amount) {
        try {
            return GridUtils.getEnergy(proxy).getEnergyDemand(amount);
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:getAEDemand: Error accessing grid:", e);
            return 0.0;
        }
    }

    public static double sendAEToNet(AEProxy proxy, double amount, Actionable mode) {
        try {
            double overflow = GridUtils.getEnergy(proxy).injectPower(amount, mode);
            return mode == Actionable.SIMULATE ? overflow : 0.0;
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:sendAEToNet: Error accessing grid:", e);
            return 0.0;
        }
    }

    public static double extractAEPower(AEProxy proxy, double amount, Actionable mode, PowerMultiplier multiplier) {
        try {
            return GridUtils.getEnergy(proxy).extractAEPower(amount, mode, multiplier);
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:extractAEPower: Error accessing grid:", e);
            return 0.0;
        }
    }

    public static ItemStack injectItemsForPower(AEProxy proxy, ItemStack stack, IActionSource source) {
        IAEItemStack toInject = (IAEItemStack)storageChannel.createStack((Object)stack.func_77946_l());
        long orgSize = toInject.getStackSize();
        try {
            IStorageGrid storageGrid = GridUtils.getStorage(proxy);
            IAEItemStack rejected = (IAEItemStack)storageGrid.getInventory((IStorageChannel)storageChannel).injectItems((IAEStack)toInject, Actionable.SIMULATE, source);
            if (rejected == null) {
                rejected = (IAEItemStack)((IAEItemStack)storageChannel.createStack((Object)stack.func_77946_l())).setStackSize(0L);
            }
            toInject.setStackSize(toInject.getStackSize() - rejected.getStackSize());
            toInject.setStackSize((long)Math.min(GridUtils.extractAEPower(proxy, toInject.getStackSize(), Actionable.SIMULATE, PowerMultiplier.CONFIG) + 0.9, (double)toInject.getStackSize()));
            if (toInject.getStackSize() > 0L) {
                rejected.add((IAEItemStack)storageGrid.getInventory((IStorageChannel)storageChannel).injectItems((IAEStack)toInject, Actionable.MODULATE, source));
                GridUtils.extractAEPower(proxy, orgSize - rejected.getStackSize(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                return rejected.getStackSize() == 0L ? ItemStack.field_190927_a : rejected.createItemStack();
            }
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:injectItemsForPower: Error accessing grid:", e);
        }
        return stack;
    }

    public static ItemStack injectItems(AEProxy proxy, ItemStack stack, Actionable mode, IActionSource source) {
        try {
            IAEItemStack rejected = (IAEItemStack)GridUtils.getStorage(proxy).getInventory((IStorageChannel)storageChannel).injectItems(storageChannel.createStack((Object)stack), mode, source);
            return rejected == null || rejected.getStackSize() == 0L ? ItemStack.field_190927_a : rejected.createItemStack();
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:injectItems: Error accessing grid:", e);
            return stack;
        }
    }

    public static void alertDevice(AEProxy proxy, IGridNode device) {
        try {
            GridUtils.getTick(proxy).alertDevice(device);
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:alertDevice: Error accessing grid:", e);
        }
    }

    public static long injectEMC(AEProxy proxy, long emc, Actionable mode, IActionSource src) {
        if (emc > 0L) {
            try {
                IEMCStorageChannel emcChannel = (IEMCStorageChannel)AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class);
                IStorageGrid storageGrid = (IStorageGrid)proxy.getGrid().getCache(IStorageGrid.class);
                IAEEMCStack rejected = (IAEEMCStack)storageGrid.getInventory((IStorageChannel)emcChannel).injectItems(emcChannel.createStack(emc), mode, src);
                return rejected == null ? emc : emc - rejected.getEMCValue();
            }
            catch (GridAccessException e) {
                CommonUtils.debugLog("GridUtils:injectEMC: Error accessing grid:", e);
            }
        }
        return 0L;
    }

    public static void addPatterns(AEProxy proxy, ICraftingMedium medium, ICraftingProviderHelper tracker) {
        try {
            for (EMCCraftingPattern pattern : GridUtils.getEMCCrafting(proxy).getPatterns()) {
                tracker.addCraftingOption(medium, (ICraftingPatternDetails)pattern);
            }
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:addPatterns: Error accessing grid:", e);
        }
    }

    public static void updatePatterns(AEProxy proxy) {
        try {
            GridUtils.getEMCCrafting(proxy).updatePatterns();
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("GridUtils:updatePatterns: Error accessing grid:", e);
        }
    }
}

