/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import java.text.DecimalFormat;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static boolean destroyAndDrop(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            if (!world.field_72995_K) {
                state.func_177230_c().func_180663_b(world, pos, state);
                NonNullList drops = NonNullList.func_191196_a();
                state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
                for (ItemStack stack : drops) {
                    CommonUtils.spawnEntItem(world, pos, stack);
                }
            }
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public static void spawnEntItem(World world, BlockPos pos, ItemStack item) {
        if (world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && !item.func_190926_b()) {
            float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack(item.func_77973_b(), item.func_190916_E(), item.func_77952_i()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)0.05f + 0.2000000029802322;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static <T> T getTE(Class<T> type, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static String formatEMC(double emc) {
        double displayValue;
        String[] preFixes = new String[]{"K", "M", "B", "T", "P", "T", "P", "E", "Z", "Y"};
        String level = "";
        int offset = 0;
        for (displayValue = emc; displayValue > 1000.0 && offset < preFixes.length; displayValue /= 1000.0) {
            level = preFixes[offset++];
        }
        DecimalFormat formatter = new DecimalFormat("#.###");
        return formatter.format(displayValue) + ' ' + level;
    }

    public static ItemStack filterForEmpty(ItemStack stack) {
        return stack.func_190916_E() <= 0 ? ItemStack.field_190927_a : stack;
    }

    public static boolean willItemsStack(ItemStack dest, ItemStack src) {
        if (dest.func_190926_b() && !src.func_190926_b()) {
            return true;
        }
        return CommonUtils.isSameItem(dest, src);
    }

    public static boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void debugLog(String message) {
        if (EqEConfig.misc.debug) {
            EquivalentEnergistics.logger.debug(message);
        }
    }

    public static void debugLog(String message, Throwable t) {
        if (EqEConfig.misc.debug) {
            EquivalentEnergistics.logger.debug(message, t);
        }
    }
}

