/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util;

import com.mordenkainen.equivalentenergistics.util.IEMCStorage;

public class EMCPool
implements IEMCStorage {
    private double currentEMC;
    private double maxEMC;
    private boolean overflow;

    public EMCPool(double currentEMC, double maxEMC, boolean overflow) {
        this.currentEMC = currentEMC;
        this.maxEMC = maxEMC;
        this.overflow = overflow;
    }

    public EMCPool() {
        this(0.0, 0.0, false);
    }

    public EMCPool(double currentEMC) {
        this(currentEMC, currentEMC, true);
    }

    public EMCPool(double currentEMC, double maxEMC) {
        this(currentEMC, maxEMC, true);
    }

    @Override
    public double getCurrentEMC() {
        return this.currentEMC;
    }

    @Override
    public void setCurrentEMC(double currentEMC) {
        this.currentEMC = !this.overflow && currentEMC > this.maxEMC ? this.maxEMC : (currentEMC < 0.0 ? 0.0 : currentEMC);
    }

    @Override
    public double getMaxEMC() {
        return this.maxEMC;
    }

    @Override
    public void setMaxEMC(double maxEMC) {
        if (!this.overflow && this.currentEMC > maxEMC) {
            this.currentEMC = maxEMC;
        }
        this.maxEMC = maxEMC;
    }

    public boolean canOverflow() {
        return this.overflow;
    }

    public void canOverflow(boolean overflow) {
        if (!overflow && this.currentEMC > this.maxEMC) {
            this.currentEMC = this.maxEMC;
        }
        this.overflow = overflow;
    }

    public double getExcess() {
        if (this.overflow && this.currentEMC > this.maxEMC) {
            return this.currentEMC - this.maxEMC;
        }
        return 0.0;
    }

    @Override
    public double getAvail() {
        if (this.currentEMC >= this.maxEMC) {
            return 0.0;
        }
        return this.maxEMC - this.currentEMC;
    }

    @Override
    public boolean isFull() {
        return this.currentEMC >= this.maxEMC;
    }

    @Override
    public boolean isEmpty() {
        return this.currentEMC == 0.0;
    }

    @Override
    public double addEMC(double emc) {
        double toAdd = emc;
        if (!this.overflow) {
            toAdd = Math.min(toAdd, this.getAvail());
        }
        this.currentEMC += toAdd;
        return toAdd;
    }

    @Override
    public double extractEMC(double emc) {
        double toExtract = Math.min(emc, this.currentEMC);
        this.currentEMC -= toExtract;
        return toExtract;
    }
}

