/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.api.cygnus;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.cygnus.ICygnusStack;

public interface ICygnusDatatype<T> {
    public Class<T> getTypeClass();

    public String getTranslationKey();

    @SideOnly(value=Side.CLIENT)
    default public List<String> describe(T thing) {
        return ImmutableList.of((Object)this.toString(thing));
    }

    public void writeToNBT(NBTTagCompound var1, T var2);

    public T readFromNBT(NBTTagCompound var1);

    public void writeToPacketBuffer(PacketBuffer var1, T var2);

    public T readFromPacketBuffer(PacketBuffer var1);

    @Nullable
    default public Object getError(T item, ICygnusStack stack) {
        return null;
    }

    default public boolean areEqual(T item1, T item2) {
        return item1.equals(item2);
    }

    default public boolean canCompare() {
        return false;
    }

    default public int compare(T item1, T item2) {
        return 0;
    }

    default public String toString(T item) {
        return item.toString();
    }

    default public int toComparator(T item) {
        return 1;
    }

    default public boolean areEqualUnchecked(Object item1, Object item2) {
        return this.areEqual(item1, item2);
    }

    default public int compareUnchecked(Object item1, Object item2) {
        return this.compare(item1, item2);
    }

    default public String toStringUnchecked(Object item) {
        return this.toString(item);
    }

    default public int toComparatorUnchecked(Object item) {
        return this.toComparator(item);
    }

    @SideOnly(value=Side.CLIENT)
    default public List<String> describeUnchecked(Object item) {
        return this.describe(item);
    }
}

