/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.ICorporeaInhibitor;
import quaternary.incorporeal.etc.helper.CorporeaHelper2;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.entity.EntityCorporeaSpark;

@Mod.EventBusSubscriber
public class BlockCorporeaInhibitor
extends Block
implements ICorporeaInhibitor,
ILexiconable {
    private static final WeakHashMap<World, Set<BlockPos>> deferredCheckPositions = new WeakHashMap();

    public BlockCorporeaInhibitor() {
        super(Material.field_151576_e);
        this.func_149711_c(5.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public boolean shouldBlockCorporea(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        BlockCorporeaInhibitor.notifyNearbyCorporeaSparksDeferred(world, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockCorporeaInhibitor.notifyNearbyCorporeaSparksDeferred(world, pos);
    }

    protected static void notifyNearbyCorporeaSparksDeferred(World world, BlockPos pos) {
        Set positions = deferredCheckPositions.computeIfAbsent(world, w -> new HashSet());
        positions.add(pos);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent e) {
        Set<BlockPos> positions;
        if (e.phase == TickEvent.Phase.END && (positions = deferredCheckPositions.get(e.world)) != null) {
            for (BlockPos pos : positions) {
                BlockCorporeaInhibitor.notifyNearbyCorporeaSparks(e.world, pos);
                positions.remove(pos);
            }
        }
    }

    private static void notifyNearbyCorporeaSparks(World world, BlockPos pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g(8.0);
        world.func_72872_a(EntityCorporeaSpark.class, aabb).forEach(CorporeaHelper2::causeSparkRelink);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof BlockCorporeaInhibitor);
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.corporeaInhibitor;
    }
}

