/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block.cygnus;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import quaternary.incorporeal.api.cygnus.ICygnusSparkable;
import quaternary.incorporeal.block.cygnus.BlockCygnusBase;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import quaternary.incorporeal.tile.cygnus.TileCygnusFunnel;
import vazkii.botania.api.state.BotaniaStateProps;

public class BlockCygnusFunnel
extends BlockCygnusBase
implements ICygnusSparkable {
    public static final PropertyEnum<EnumFacing> FACING = BotaniaStateProps.FACING;
    public static final PropertyEnum<ArrowLight> ARROW_LIGHT = PropertyEnum.func_177709_a((String)"arrow_light", ArrowLight.class);

    public BlockCygnusFunnel() {
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP).func_177226_a(ARROW_LIGHT, (Comparable)((Object)ArrowLight.OFF)));
    }

    @Override
    public boolean acceptsCygnusSpark(World world, IBlockState state, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos updaterPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCygnusFunnel) {
            TileCygnusFunnel funnel = (TileCygnusFunnel)tile;
            funnel.onNeighborChange();
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCygnusFunnel) {
            ((TileCygnusFunnel)tile).updateArrowStatus(pos, (EnumFacing)state.func_177229_b(FACING));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCygnusFunnel();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ARROW_LIGHT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta % 6)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = EtcHelpers.getTileEntityThreadsafe(world, pos);
        if (tile instanceof TileCygnusFunnel) {
            TileCygnusFunnel funnel = (TileCygnusFunnel)tile;
            return state.func_177226_a(ARROW_LIGHT, (Comparable)((Object)ArrowLight.OFF.wrap(funnel.isBackLit(), funnel.isFrontLit())));
        }
        return state;
    }

    public static enum ArrowLight implements IStringSerializable
    {
        OFF,
        FRONT,
        BACK,
        BOTH;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public ArrowLight wrap(boolean back, boolean front) {
            if (back) {
                return front ? BOTH : BACK;
            }
            return front ? FRONT : OFF;
        }
    }
}

