/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.block.soulcore;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import quaternary.incorporeal.tile.soulcore.AbstractTileSoulCore;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.entity.EntityDoppleganger;

public abstract class AbstractBlockSoulCore
extends Block
implements ILexiconable,
IWandHUD {
    protected AbstractBlockSoulCore() {
        super(Material.field_151594_q);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!EntityDoppleganger.isTruePlayer((Entity)player)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTileSoulCore) {
            return ((AbstractTileSoulCore)tile).click(player);
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTileSoulCore) {
            return ((AbstractTileSoulCore)tile).getComparatorValue();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTileSoulCore) {
            ((AbstractTileSoulCore)tile).renderHUD(mc, res, world, pos);
        } else {
            HUDHandler.drawSimpleManaHUD((int)0xFF0000, (int)1, (int)1, (String)"Missing TileEntity?", (ScaledResolution)res);
        }
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.soulCores;
    }
}

