/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import quaternary.incorporeal.IncorporeticConfig;
import quaternary.incorporeal.block.IncorporeticBlocks;
import quaternary.incorporeal.block.cygnus.IncorporeticCygnusBlocks;
import quaternary.incorporeal.client.IgnoreAllStateMapper;
import quaternary.incorporeal.client.entityrenderer.RenderEntityCygnusMasterSpark;
import quaternary.incorporeal.client.entityrenderer.RenderEntityCygnusRegularSpark;
import quaternary.incorporeal.client.entityrenderer.RenderEntityNothing;
import quaternary.incorporeal.client.model.CygnusWordModelLoader;
import quaternary.incorporeal.client.tesr.RenderItemSoulCore;
import quaternary.incorporeal.client.tesr.RenderTileCorporeaSparkTinkerer;
import quaternary.incorporeal.client.tesr.RenderTileSoulCore;
import quaternary.incorporeal.client.tesr.cygnus.RenderTileCygnusCrystalCube;
import quaternary.incorporeal.client.tesr.cygnus.RenderTileCygnusRetainer;
import quaternary.incorporeal.client.tesr.decorative.RenderTileUnstableCube;
import quaternary.incorporeal.entity.EntityFracturedSpaceCollector;
import quaternary.incorporeal.entity.EntityPotionSoulCoreCollector;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.entity.cygnus.EntityCygnusRegularSpark;
import quaternary.incorporeal.flower.SubTileSanvocalia;
import quaternary.incorporeal.flower.SubTileSweetAlexum;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.item.cygnus.IncorporeticCygnusItems;
import quaternary.incorporeal.item.cygnus.ItemCygnusCard;
import quaternary.incorporeal.tile.TileCorporeaSparkTinkerer;
import quaternary.incorporeal.tile.cygnus.TileCygnusCrystalCube;
import quaternary.incorporeal.tile.cygnus.TileCygnusRetainer;
import quaternary.incorporeal.tile.decorative.TileUnstableCube;
import quaternary.incorporeal.tile.soulcore.TileCorporeaSoulCore;
import quaternary.incorporeal.tile.soulcore.TileEnderSoulCore;
import quaternary.incorporeal.tile.soulcore.TilePotionSoulCore;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.SubTileEntity;

@Mod.EventBusSubscriber(modid="incorporeal", value={Side.CLIENT})
public final class ClientRegistryEvents {
    private ClientRegistryEvents() {
    }

    @SubscribeEvent
    public static void models(ModelRegistryEvent e) {
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.FRAME_TINKERER);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.CORPOREA_INHIBITOR);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.CORPOREA_SPARK_TINKERER);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.CORPOREA_SOLIDIFIER);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.NATURAL_REPEATER);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.NATURAL_COMPARATOR);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.CORPOREA_RETAINER_DECREMENTER);
        ClientRegistryEvents.setSimpleModel(IncorporeticItems.CORPOREA_TICKET);
        ClientRegistryEvents.setSimpleModel(IncorporeticItems.TICKET_CONJURER);
        ClientRegistryEvents.setSimpleModel(IncorporeticItems.FRACTURED_SPACE_ROD);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.DECORATIVE_RED_STRING);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticItems.DECORATIVE_CORPOREA);
        ClientRegistryEvents.setSimpleModel(IncorporeticCygnusItems.MASTER_CYGNUS_SPARK);
        ClientRegistryEvents.setSimpleModel(IncorporeticCygnusItems.CYGNUS_SPARK);
        ClientRegistryEvents.setSimpleModel(IncorporeticCygnusItems.CYGNUS_TICKET);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticCygnusItems.WORD);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticCygnusItems.CRYSTAL_CUBE);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticCygnusItems.FUNNEL);
        ClientRegistryEvents.setSimpleModel((Item)IncorporeticCygnusItems.RETAINER);
        ClientRegistryEvents.setCygnusCardMeshDefinition(IncorporeticCygnusItems.WORD_CARD, "word_card");
        ClientRegistryEvents.setCygnusCardMeshDefinition(IncorporeticCygnusItems.CRYSTAL_CUBE_CARD, "crystal_cube_card");
        ClientRegistryEvents.set16DataValuesPointingAtSameModel((Item)IncorporeticItems.DECORATIVE_UNSTABLE_CUBE);
        ClientRegistryEvents.setFlowerModel(SubTileSanvocalia.class, "sanvocalia");
        ClientRegistryEvents.setFlowerModel(SubTileSanvocalia.Mini.class, "sanvocalia_chibi");
        ClientRegistryEvents.setFlowerModel(SubTileSweetAlexum.class, "sweet_alexum");
        ClientRegistryEvents.setFlowerModel(SubTileSweetAlexum.Mini.class, "sweet_alexum_chibi");
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.FRAME_TINKERER);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.CORPOREA_SPARK_TINKERER);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.CORPOREA_RETAINER_DECREMENTER);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.ENDER_SOUL_CORE);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.CORPOREA_SOUL_CORE);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticBlocks.DECORATIVE_UNSTABLE_CUBE);
        ClientRegistryEvents.setIgnoreAllStateMapper(IncorporeticCygnusBlocks.WORD);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCorporeaSparkTinkerer.class, (TileEntitySpecialRenderer)new RenderTileCorporeaSparkTinkerer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileUnstableCube.class, (TileEntitySpecialRenderer)new RenderTileUnstableCube());
        RenderTileSoulCore enderRender = new RenderTileSoulCore(new ResourceLocation("incorporeal", "textures/entity/ender_soul_core.png"));
        RenderTileSoulCore corporeaRender = new RenderTileSoulCore(new ResourceLocation("incorporeal", "textures/entity/corporea_soul_core.png"));
        RenderTileSoulCore potionRender = new RenderTileSoulCore(new ResourceLocation("incorporeal", "textures/entity/potion_soul_core.png"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnderSoulCore.class, enderRender);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCorporeaSoulCore.class, corporeaRender);
        ClientRegistry.bindTileEntitySpecialRenderer(TilePotionSoulCore.class, potionRender);
        ClientRegistry.bindTileEntitySpecialRenderer(TileCygnusRetainer.class, (TileEntitySpecialRenderer)new RenderTileCygnusRetainer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCygnusCrystalCube.class, (TileEntitySpecialRenderer)new RenderTileCygnusCrystalCube());
        ClientRegistryEvents.setTEISRModel((Item)IncorporeticItems.ENDER_SOUL_CORE, new RenderItemSoulCore(enderRender));
        ClientRegistryEvents.setTEISRModel((Item)IncorporeticItems.CORPOREA_SOUL_CORE, new RenderItemSoulCore(corporeaRender));
        ClientRegistryEvents.setTEISRModel((Item)IncorporeticItems.POTION_SOUL_CORE, new RenderItemSoulCore(potionRender));
        ClientRegistryEvents.setTEISRModel(IncorporeticItems.SOUL_CORE_FRAME, new RenderItemSoulCore(new RenderTileSoulCore(new ResourceLocation("incorporeal", "textures/entity/soul_core_frame.png"))));
    }

    @SubscribeEvent
    public static void blockColors(ColorHandlerEvent.Block e) {
        BlockColors bc = e.getBlockColors();
        bc.func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 ? ((EnumDyeColor)state.func_177229_b((IProperty)BotaniaStateProps.COLOR)).field_193351_w : 0xFFFFFF, new Block[]{IncorporeticBlocks.DECORATIVE_UNSTABLE_CUBE});
    }

    @SubscribeEvent
    public static void itemColors(ColorHandlerEvent.Item e) {
        ItemColors ic = e.getItemColors();
        ic.func_186730_a((stack, tintIndex) -> tintIndex == 0 ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()).field_193351_w : 0xFFFFFF, new Item[]{IncorporeticItems.DECORATIVE_UNSTABLE_CUBE});
    }

    public static void preinit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityCygnusRegularSpark.class, RenderEntityCygnusRegularSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCygnusMasterSpark.class, RenderEntityCygnusMasterSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFracturedSpaceCollector.class, RenderEntityNothing::new);
        if (!IncorporeticConfig.SoulCore.DEBUG_BLOODCORE_ENTITIES) {
            RenderingRegistry.registerEntityRenderingHandler(EntityPotionSoulCoreCollector.class, RenderEntityNothing::new);
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CygnusWordModelLoader());
    }

    private static void setSimpleModel(Item i) {
        ResourceLocation res = (ResourceLocation)Preconditions.checkNotNull((Object)i.getRegistryName());
        ModelResourceLocation mrl = new ModelResourceLocation(res, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)mrl);
    }

    private static void setTEISRModel(Item i, TileEntityItemStackRenderer rend) {
        ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("incorporeal", "dummy_builtin_blocktransforms"), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)mrl);
        i.setTileEntityItemStackRenderer(rend);
    }

    private static void set16DataValuesPointingAtSameModel(Item i) {
        ResourceLocation res = (ResourceLocation)Preconditions.checkNotNull((Object)i.getRegistryName());
        for (int color = 0; color < 16; ++color) {
            ModelResourceLocation mrl = new ModelResourceLocation(res, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)color, (ModelResourceLocation)mrl);
        }
    }

    private static void setIgnoreAllStateMapper(Block b) {
        ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new IgnoreAllStateMapper(b));
    }

    private static void setIgnoringStateMapper(Block b, IProperty<?> ... props) {
        StateMap.Builder builder = new StateMap.Builder();
        for (int i = 0; i < props.length; ++i) {
            builder.func_178442_a(new IProperty[]{props[i]});
        }
        ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)builder.func_178441_a());
    }

    private static void setFlowerModel(Class<? extends SubTileEntity> flower, String name) {
        ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("incorporeal", name), "normal");
        BotaniaAPIClient.registerSubtileModel(flower, (ModelResourceLocation)mrl);
    }

    private static <T> void setCygnusCardMeshDefinition(ItemCygnusCard<T> card, String path) {
        String path2 = "cygnus/" + path + "/";
        ModelLoader.setCustomMeshDefinition(card, stack -> {
            ResourceLocation valueName = card.readValueName(stack);
            return new ModelResourceLocation(new ResourceLocation(valueName.func_110624_b(), path2 + valueName.func_110623_a()), "inventory");
        });
        ModelLoader.registerItemVariants(card, (ResourceLocation[])((ResourceLocation[])card.registry.allKeys().stream().map(res -> new ResourceLocation(res.func_110624_b(), path2 + res.func_110623_a())).toArray(ResourceLocation[]::new)));
    }
}

