/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.entityrenderer;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import quaternary.incorporeal.client.IncorporeticClientIcons;
import quaternary.incorporeal.client.RenderHelpers;
import quaternary.incorporeal.client.event.IncorporeticClientTickHandler;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.CygnusStack;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.render.entity.RenderSparkBase;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public class RenderEntityCygnusMasterSpark
extends RenderSparkBase<EntityCygnusMasterSpark> {
    public RenderEntityCygnusMasterSpark(RenderManager manager) {
        super(manager);
    }

    public void doRender(@Nonnull EntityCygnusMasterSpark ent, double x, double y, double z, float yaw, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        float distanceTo = MathHelper.pointDistanceSpace((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)mc.field_71439_g.field_70165_t, (double)mc.field_71439_g.field_70163_u, (double)mc.field_71439_g.field_70161_v);
        if (distanceTo > 40.0f) {
            return;
        }
        super.func_76986_a((Entity)ent, x, y, z, yaw, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        CygnusStack stack = ent.getCygnusStack();
        if (stack != null && !stack.isEmpty()) {
            boolean disableDepth = ItemMonocle.hasMonocle((EntityPlayer)mc.field_71439_g);
            FontRenderer font = mc.field_71466_p;
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(180.0f - IncorporeticClientTickHandler.easedYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-IncorporeticClientTickHandler.easedPitch * 0.85f), (float)1.0f, (float)0.0f, (float)0.0f);
            float scale = EtcHelpers.rangeRemap(distanceTo, 5.0f, 25.0f, 0.03125f, 0.083333336f);
            GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
            GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
            RenderHelpers.useFullbrightLightmap();
            if (disableDepth) {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179147_l();
            int alpha = (int)EtcHelpers.rangeRemap(distanceTo, 20.0f, 40.0f, 255.0f, 3.0f) & 0xFF;
            int textColor = 0xFFFFFF | alpha << 24;
            for (int i = 0; i < stack.depth(); ++i) {
                stack.peek(i).ifPresent(o -> {
                    String toDraw = CygnusDatatypeHelpers.forClass(o.getClass()).toStringUnchecked(o);
                    font.func_78276_b(toDraw, -font.func_78256_a(toDraw) / 2, 0, textColor);
                    GlStateManager.func_179109_b((float)0.0f, (float)-14.0f, (float)0.0f);
                });
            }
            if (disableDepth) {
                GlStateManager.func_179126_j();
            }
        }
        GlStateManager.func_179121_F();
    }

    protected TextureAtlasSprite getBaseIcon(EntityCygnusMasterSpark entity) {
        return IncorporeticClientIcons.masterCygnusSpark;
    }

    protected TextureAtlasSprite getSpinningIcon(EntityCygnusMasterSpark entity) {
        return MiscellaneousIcons.INSTANCE.corporeaIconStar;
    }

    protected void colorSpinningIcon(EntityCygnusMasterSpark entity, float a) {
        int rgb = entity.getTint().field_193351_w;
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }
}

