/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.event;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import quaternary.incorporeal.block.decorative.BlockUnstableCube;
import quaternary.incorporeal.block.soulcore.AbstractBlockSoulCore;
import quaternary.incorporeal.client.tesr.RenderTileSoulCore;
import quaternary.incorporeal.client.tesr.decorative.RenderTileUnstableCube;
import quaternary.incorporeal.tile.decorative.TileUnstableCube;
import quaternary.incorporeal.tile.soulcore.AbstractTileSoulCore;

@Mod.EventBusSubscriber(modid="incorporeal", value={Side.CLIENT})
public final class BlockHighlightEventHandler {
    private static final AxisAlignedBB UNSTABLE_CUBE_HIGHLIGHT_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_186662_g(0.002);
    private static final AxisAlignedBB SOUL_CORE_HIGHLIGHT_AABB = new AxisAlignedBB(0.05, 0.05, 0.05, 0.95, 0.95, 0.95).func_186662_g(0.002);

    private BlockHighlightEventHandler() {
    }

    @SubscribeEvent
    public static void renderBlockHighlight(DrawBlockHighlightEvent e) {
        RayTraceResult ray = e.getTarget();
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ray.func_178782_a();
            World world = e.getPlayer().field_70170_p;
            TileEntity tile = world.func_175625_s(pos);
            Block b = world.func_180495_p(pos).func_177230_c();
            if (b instanceof BlockUnstableCube && tile instanceof TileUnstableCube) {
                BlockHighlightEventHandler.highlight(e, (x, y, z, partial) -> {
                    RenderTileUnstableCube.doTransformations((TileUnstableCube)tile, partial, x, y, z);
                    RenderGlobal.func_189697_a((AxisAlignedBB)UNSTABLE_CUBE_HIGHLIGHT_AABB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                });
            } else if (b instanceof AbstractBlockSoulCore && tile instanceof AbstractTileSoulCore) {
                BlockHighlightEventHandler.highlight(e, (x, y, z, partial) -> {
                    RenderTileSoulCore.performHighlightTransformations((AbstractTileSoulCore)tile, partial, x, y, z);
                    GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
                    RenderGlobal.func_189697_a((AxisAlignedBB)SOUL_CORE_HIGHLIGHT_AABB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                });
            }
        }
    }

    private static void highlight(DrawBlockHighlightEvent e, IHighlightHandler h) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        EntityPlayer player = e.getPlayer();
        BlockPos pos = e.getTarget().func_178782_a();
        double x = (double)pos.func_177958_n() - (player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks);
        double y = (double)pos.func_177956_o() - (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks);
        double z = (double)pos.func_177952_p() - (player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks);
        GlStateManager.func_179094_E();
        h.apply(x, y, z, Minecraft.func_71410_x().func_184121_ak());
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        e.setCanceled(true);
    }

    private static interface IHighlightHandler {
        public void apply(double var1, double var3, double var5, float var7);
    }
}

