/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.event;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.CygnusRegistries;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.item.ItemTicketConjurer;
import quaternary.incorporeal.item.cygnus.IncorporeticCygnusItems;
import quaternary.incorporeal.tile.cygnus.TileCygnusCrystalCube;
import quaternary.incorporeal.tile.cygnus.TileCygnusRetainer;
import quaternary.incorporeal.tile.cygnus.TileCygnusWord;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

@Mod.EventBusSubscriber(modid="incorporeal", value={Side.CLIENT})
public final class PostRenderGameOverlayEventHandler {
    private static ItemStack cygnusCrystalCubeCardStack = new ItemStack((Item)IncorporeticCygnusItems.CRYSTAL_CUBE_CARD);
    private static final ItemStack cygnusWordCardStack = new ItemStack((Item)IncorporeticCygnusItems.WORD_CARD);

    private PostRenderGameOverlayEventHandler() {
    }

    @SubscribeEvent
    public static void onDrawScreen(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            RayTraceResult trace;
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack heldMain = mc.field_71439_g.func_184614_ca();
            ItemStack heldOff = mc.field_71439_g.func_184592_cb();
            ScaledResolution res = e.getResolution();
            if (mc.field_71462_r instanceof GuiChat && (heldMain.func_77973_b() instanceof ItemTicketConjurer || heldOff.func_77973_b() instanceof ItemTicketConjurer)) {
                PostRenderGameOverlayEventHandler.drawConjurerOverlay(mc, res);
            }
            if ((trace = mc.field_71476_x) != null) {
                BlockPos hitPos = null;
                IBlockState hitState = null;
                TileEntity hitTile = null;
                if (trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                    hitPos = trace.func_178782_a();
                    hitState = mc.field_71441_e.func_180495_p(hitPos);
                    hitTile = mc.field_71441_e.func_175625_s(hitPos);
                }
                if (hitState != null) {
                    if (hitTile instanceof TileCygnusCrystalCube) {
                        PostRenderGameOverlayEventHandler.drawCygnusCrystalCubeOverlay(res, (TileCygnusCrystalCube)hitTile);
                    } else if (hitTile instanceof TileCygnusRetainer) {
                        PostRenderGameOverlayEventHandler.drawCygnusRetainerOverlay(res, (TileCygnusRetainer)hitTile);
                    } else if (hitTile instanceof TileCygnusWord) {
                        PostRenderGameOverlayEventHandler.drawCygnusWordOverlay(res, (TileCygnusWord)hitTile);
                    }
                }
            }
        }
    }

    private static void drawConjurerOverlay(Minecraft mc, ScaledResolution res) {
        String txt0 = net.minecraft.client.resources.I18n.func_135052_a((String)"incorporeal.etc.holdingTicketConjurer0", (Object[])new Object[0]);
        String txt1 = TextFormatting.GRAY + net.minecraft.client.resources.I18n.func_135052_a((String)"incorporeal.etc.holdingTicketConjurer1", (Object[])new Object[0]);
        String txt2 = TextFormatting.GRAY + net.minecraft.client.resources.I18n.func_135052_a((String)"incorporeal.etc.holdingTicketConjurer2", (Object[])new Object[0]);
        int l = Math.max(mc.field_71466_p.func_78256_a(txt0), Math.max(mc.field_71466_p.func_78256_a(txt1), mc.field_71466_p.func_78256_a(txt2))) + 20;
        int x = res.func_78326_a() - l - 20;
        TileCorporeaIndex.getInputHandler();
        int y = res.func_78328_b() - (TileCorporeaIndex.InputHandler.getNearbyIndexes((EntityPlayer)mc.field_71439_g).isEmpty() ? 60 : 110);
        Gui.func_73734_a((int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x44000000);
        Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x44000000);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_180450_b(new ItemStack((Item)IncorporeticItems.TICKET_CONJURER), x, y + 10);
        RenderHelper.func_74518_a();
        mc.field_71466_p.func_175063_a(txt0, (float)(x + 20), (float)y, 0xFFFFFF);
        mc.field_71466_p.func_175063_a(txt1, (float)(x + 20), (float)(y + 14), 0xFFFFFF);
        mc.field_71466_p.func_175063_a(txt2, (float)(x + 20), (float)(y + 24), 0xFFFFFF);
    }

    private static void drawCygnusCrystalCubeOverlay(ScaledResolution res, TileCygnusCrystalCube tile) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("cygnusCrystalCubeOverlay");
        IncorporeticCygnusItems.CRYSTAL_CUBE_CARD.set(cygnusCrystalCubeCardStack, tile.getCondition());
        ResourceLocation cond = CygnusRegistries.CONDITIONS.nameOf(tile.getCondition());
        String name = net.minecraft.client.resources.I18n.func_135052_a((String)(cond.func_110624_b() + ".cygnus.condition." + cond.func_110623_a()), (Object[])new Object[0]);
        int strlen = mc.field_71466_p.func_78256_a(name);
        int w = res.func_78326_a();
        int h = res.func_78328_b();
        Gui.func_73734_a((int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)(h / 2 + 10), (int)0x44000000);
        Gui.func_73734_a((int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(h / 2 + 12), (int)0x44000000);
        mc.field_71466_p.func_175063_a(name, (float)(w / 2 + 30), (float)(h / 2 - 6), 8767180);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_180450_b(cygnusCrystalCubeCardStack, w / 2 + 10, h / 2 - 10);
        RenderHelper.func_74518_a();
        profiler.func_76319_b();
    }

    private static void drawCygnusRetainerOverlay(ScaledResolution res, TileCygnusRetainer tile) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("cygnusRetainerOverlay");
        ArrayList<String> lines = new ArrayList<String>();
        if (tile.hasRetainedObject()) {
            Object o = tile.getRetainedObject();
            ICygnusDatatype<?> type = CygnusDatatypeHelpers.forClass(o.getClass());
            String typeName = net.minecraft.client.resources.I18n.func_135052_a((String)type.getTranslationKey(), (Object[])new Object[0]);
            lines.add(TextFormatting.GREEN + I18n.func_74837_a((String)EtcHelpers.vowelizeTranslationKey("incorporeal.cygnus.retainer.some", typeName), (Object[])new Object[]{typeName}));
            lines.addAll(type.describeUnchecked(o));
        } else {
            lines.add(TextFormatting.RED + net.minecraft.client.resources.I18n.func_135052_a((String)"incorporeal.cygnus.retainer.none", (Object[])new Object[0]));
        }
        int boxWidth = 0;
        for (String s : lines) {
            int swidth = mc.field_71466_p.func_78256_a(s);
            if (swidth <= boxWidth) continue;
            boxWidth = swidth;
        }
        int boxHeight = (lines.size() - 1) * 12;
        int w = res.func_78326_a();
        int h = res.func_78328_b();
        Gui.func_73734_a((int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + boxWidth + 12), (int)(h / 2 + boxHeight), (int)0x44000000);
        Gui.func_73734_a((int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + boxWidth + 14), (int)(h / 2 + boxHeight + 2), (int)0x44000000);
        int y = -10;
        for (String s : lines) {
            mc.field_71466_p.func_175063_a(s, (float)(w / 2 + 10), (float)(h / 2 + y), 0xFFFFFF);
            y += 12;
        }
        profiler.func_76319_b();
    }

    private static void drawCygnusWordOverlay(ScaledResolution res, TileCygnusWord tile) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("cygnusWordOverlay");
        IncorporeticCygnusItems.WORD_CARD.set(cygnusWordCardStack, tile.getAction());
        ResourceLocation cond = CygnusRegistries.ACTIONS.nameOf(tile.getAction());
        String name = net.minecraft.client.resources.I18n.func_135052_a((String)(cond.func_110624_b() + ".cygnus.action." + cond.func_110623_a()), (Object[])new Object[0]);
        int strlen = mc.field_71466_p.func_78256_a(name);
        int w = res.func_78326_a();
        int h = res.func_78328_b();
        Gui.func_73734_a((int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)(h / 2 + 10), (int)0x44000000);
        Gui.func_73734_a((int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(h / 2 + 12), (int)0x44000000);
        mc.field_71466_p.func_175063_a(name, (float)(w / 2 + 30), (float)(h / 2 - 6), 7326862);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_180450_b(cygnusWordCardStack, w / 2 + 10, h / 2 - 10);
        RenderHelper.func_74518_a();
        profiler.func_76319_b();
    }
}

