/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.client.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.ISimpleRegistry;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.client.model.CygnusWordBakedModel;

public class CygnusWordModel
implements IModel {
    private static Set<ResourceLocation> actionResources;
    private static Map<Consumer<ICygnusStack>, IModel> actionModels;
    private static Map<Consumer<ICygnusStack>, IBakedModel> actionBakedModels;

    public CygnusWordModel() {
        CygnusWordModel.initModelsIfNeeded();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        CygnusWordModel.initModelsIfNeeded();
        CygnusWordModel.bakeModelsIfNeeded(state, format, bakedTextureGetter);
        return new CygnusWordBakedModel(actionBakedModels);
    }

    public Collection<ResourceLocation> getDependencies() {
        return actionResources;
    }

    public static void initModelsIfNeeded() {
        if (actionResources == null) {
            actionResources = new HashSet<ResourceLocation>();
            actionModels = new HashMap<Consumer<ICygnusStack>, IModel>();
            ISimpleRegistry<Consumer<ICygnusStack>> actions = Incorporeal.API.getCygnusStackActionRegistry();
            for (Map.Entry entry : actions.backingMap().entrySet()) {
                ResourceLocation actionName = (ResourceLocation)entry.getKey();
                ResourceLocation actionModelLocation = new ResourceLocation(actionName.func_110624_b(), "block/cygnus/word/" + actionName.func_110623_a());
                IModel actionModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)actionModelLocation, (String)("Cannot load model for " + actionName + " (location '" + actionModelLocation + "')"));
                actionModels.put((Consumer<ICygnusStack>)entry.getValue(), actionModel);
                actionResources.addAll(actionModel.getDependencies());
            }
        }
    }

    public static void bakeModelsIfNeeded(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (actionBakedModels == null) {
            actionBakedModels = new HashMap<Consumer<ICygnusStack>, IBakedModel>();
            actionModels.forEach((action, model) -> actionBakedModels.put((Consumer<ICygnusStack>)action, model.bake(state, format, bakedTextureGetter)));
        }
    }

    public static void dumpModelCache() {
        actionResources = null;
        actionModels = null;
        actionBakedModels = null;
    }
}

