/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import quaternary.incorporeal.compat.crafttweaker.RecipeSkytouchingCT;
import quaternary.incorporeal.recipe.skytouch.IncorporeticSkytouchingRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.incorporeal.Skytouching")
public class CTSkytouching {
    public static List<IAction> ACTIONS = new LinkedList<IAction>();

    @ZenMethod
    public static void addRecipe(IItemStack out, IIngredient in) {
        CTSkytouching.addRecipe(out, in, 260, 300, 4);
    }

    @ZenMethod
    public static void addRecipe(IItemStack out, IIngredient in, int minY, int maxY, int multiplier) {
        CTSkytouching.act(() -> IncorporeticSkytouchingRecipes.register(new RecipeSkytouchingCT(out, in, minY, maxY, multiplier)), "adding new skytouching recipe:", "output:", out.toCommandString(), "input:", in.toCommandString(), "minY:", minY, "maxY:", maxY, "multiplier:", multiplier);
    }

    @ZenMethod
    public static void remove(IItemStack removalTarget) {
        CTSkytouching.act(() -> IncorporeticSkytouchingRecipes.removeIf(r -> {
            for (ItemStack inStack : r.getGenericInputs()) {
                if (!CraftTweakerMC.matches((IItemStack)removalTarget, (ItemStack)inStack)) continue;
                return true;
            }
            return false;
        }), "removing recipes that match", removalTarget.toCommandString());
    }

    @ZenMethod
    public static void removeAll() {
        CTSkytouching.act(IncorporeticSkytouchingRecipes::clear, "clearing all skytouching recipes >:D");
    }

    private static void act(final Runnable action, final Object ... message) {
        ACTIONS.add(new IAction(){

            public void apply() {
                action.run();
            }

            public String describe() {
                StringBuilder wow = new StringBuilder();
                for (int i = 0; i < message.length; ++i) {
                    wow.append(message[i].toString());
                    if (i == message.length - 1) continue;
                    wow.append(' ');
                }
                return wow.toString();
            }
        });
    }

    public static void init() {
        try {
            ACTIONS.forEach(CraftTweakerAPI::apply);
        }
        catch (Exception e) {
            CraftTweakerAPI.logError((String)"There was a problem applying an Incorporeal action");
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            CraftTweakerAPI.logError((String)out.toString());
        }
    }
}

