/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.compat.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import quaternary.incorporeal.api.recipe.IRecipeSkytouching;
import quaternary.incorporeal.etc.helper.EtcHelpers;

public class RecipeSkytouchingCT
implements IRecipeSkytouching {
    private final IItemStack out;
    private final IIngredient ingredient;
    private final int minY;
    private final int maxY;
    private final int multiplier;

    public RecipeSkytouchingCT(IItemStack out, IIngredient ingredient, int minY, int maxY, int multiplier) {
        this.out = out;
        this.ingredient = ingredient;
        this.minY = minY;
        this.maxY = maxY;
        this.multiplier = multiplier;
    }

    public RecipeSkytouchingCT(IItemStack out, IIngredient ingredient) {
        this(out, ingredient, 260, 300, 4);
    }

    @Override
    public boolean matches(EntityItem ent) {
        return ent.field_70163_u >= (double)this.minY && this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)ent.func_92059_d()));
    }

    @Override
    public List<ItemStack> getOutputs(EntityItem ent) {
        int itemsToDispense;
        double bonus = EtcHelpers.rangeRemap(ent.field_70163_u, (double)this.minY, (double)this.maxY, 1.0, (double)this.multiplier);
        ItemStack outStack = CraftTweakerMC.getItemStack((IItemStack)this.out);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (itemsToDispense <= this.out.getMaxStackSize()) {
            ItemStack outC = outStack.func_77946_l();
            outC.func_190920_e(itemsToDispense);
            result.add(outC);
        } else {
            int dispensedItems;
            for (itemsToDispense = ent.func_92059_d().func_190916_E() * (int)Math.round((double)this.out.getAmount() * bonus); itemsToDispense > 0; itemsToDispense -= dispensedItems) {
                dispensedItems = Math.min(itemsToDispense, this.out.getMaxStackSize());
                ItemStack outC = outStack.func_77946_l();
                outC.func_190920_e(dispensedItems);
                result.add(outC);
            }
        }
        if (this.ingredient.hasNewTransformers()) {
            IItemStack istack = (IItemStack)this.ingredient.getItems().get(0);
            istack = this.ingredient.applyNewTransform(istack);
            result.add(CraftTweakerMC.getItemStack((IItemStack)istack));
        }
        result.removeIf(ItemStack::func_190926_b);
        return result;
    }

    @Override
    public List<ItemStack> getGenericInputs() {
        return this.ingredient.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
    }

    @Override
    public ItemStack getGenericOutput() {
        return CraftTweakerMC.getItemStack((IItemStack)this.out);
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMultiplier() {
        return this.multiplier;
    }
}

