/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.compat.infraredstone;

import com.elytradev.infraredstone.InfraRedstone;
import com.elytradev.infraredstone.api.IInfraRedstone;
import com.elytradev.infraredstone.logic.impl.InfraRedstoneHandler;
import com.elytradev.infraredstone.tile.TileEntityDiode;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import quaternary.incorporeal.api.cygnus.ICygnusFunnelable;
import quaternary.incorporeal.cygnus.cap.AttachCapabilitiesEventHandler;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.etc.LazyGenericCapabilityProvider;
import quaternary.incorporeal.tile.cygnus.TileCygnusFunnel;

public class InRedAttachCapabilitiesEventHandler {
    public static final Capability<IInfraRedstone> INFRA_READABLE_CAP = InfraRedstone.CAPABILITY_IR;
    private static final ResourceLocation FUNNEL_HANDLER = AttachCapabilitiesEventHandler.FUNNEL_HANDLER;
    private static final ResourceLocation INRED_CABLE_HANDLER = new ResourceLocation("incorporeal", "inred_compat_cable");

    @SubscribeEvent
    public static void tileCaps(AttachCapabilitiesEvent<TileEntity> e) {
        TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof TileCygnusFunnel) {
            e.addCapability(INRED_CABLE_HANDLER, new LazyGenericCapabilityProvider<IInfraRedstone>(INFRA_READABLE_CAP, () -> InfraRedstoneHandler.ALWAYS_OFF));
            return;
        }
        if (tile instanceof TileEntityDiode) {
            e.addCapability(FUNNEL_HANDLER, new LazyGenericCapabilityProvider<ICygnusFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, () -> new InfraDiodeFunnelable((TileEntityDiode)tile)));
            return;
        }
        if (tile.hasCapability(INFRA_READABLE_CAP, null)) {
            e.addCapability(FUNNEL_HANDLER, new LazyGenericCapabilityProvider<ICygnusFunnelable>(IncorporeticCygnusCapabilities.FUNNEL_CAP, () -> new InfraReadableFunnelable((IInfraRedstone)tile.getCapability(INFRA_READABLE_CAP, null))));
            return;
        }
    }

    private static class InfraDiodeFunnelable
    implements ICygnusFunnelable {
        private final TileEntityDiode diode;

        public InfraDiodeFunnelable(TileEntityDiode diode) {
            this.diode = diode;
        }

        @Override
        public boolean canGiveCygnusItem() {
            return true;
        }

        @Override
        public boolean canAcceptCygnusItem() {
            return true;
        }

        @Override
        @Nullable
        public Object giveItemToCygnus() {
            return BigInteger.valueOf(this.diode.getMask());
        }

        @Override
        public void acceptItemFromCygnus(Object item) {
            if (item instanceof BigInteger) {
                int newMask = Math.abs(((BigInteger)item).intValue()) & 0x3F;
                int mask = this.diode.getMask();
                int bitId = 0;
                for (int i = 1; i <= 32; i <<= 1) {
                    if ((mask & i) != (newMask & i)) {
                        this.diode.setMask(bitId);
                    }
                    ++bitId;
                }
            }
        }
    }

    private static class InfraReadableFunnelable
    implements ICygnusFunnelable {
        private final IInfraRedstone read;

        public InfraReadableFunnelable(IInfraRedstone read) {
            this.read = read;
        }

        @Override
        public boolean canGiveCygnusItem() {
            return true;
        }

        @Override
        @Nullable
        public Object giveItemToCygnus() {
            return BigInteger.valueOf(this.read.getSignalValue());
        }
    }
}

