/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.cygnus.CygnusError;

public final class CygnusDatatypeHelpers {
    private static final BiMap<Class, ICygnusDatatype<?>> typesByClass = HashBiMap.create();
    private static final BiMap<Integer, ICygnusDatatype<?>> typesByNetworkID = HashBiMap.create();
    private static BiMap<ResourceLocation, ICygnusDatatype<?>> typesByResourceLocation;

    private CygnusDatatypeHelpers() {
    }

    public static void init() {
        if (!typesByClass.isEmpty()) {
            throw new IllegalStateException("Already initialized");
        }
        typesByResourceLocation = Incorporeal.API.getCygnusDatatypeRegistry().backingMap();
        int i = 0;
        for (ICygnusDatatype type : typesByResourceLocation.values()) {
            typesByClass.put(type.getTypeClass(), (Object)type);
            typesByNetworkID.put((Object)i, (Object)type);
            ++i;
        }
    }

    public static <T> ICygnusDatatype<T> forClass(Class<T> classs) {
        ICygnusDatatype type = (ICygnusDatatype)typesByClass.get(classs);
        if (type == null) {
            throw new IllegalArgumentException("No Cygnus datatype registered for class " + classs);
        }
        return type;
    }

    public static <T> void writeToNBT(NBTTagCompound nbt, T item) {
        ICygnusDatatype datatype = (ICygnusDatatype)typesByClass.get(item.getClass());
        if (datatype == null) {
            throw new IllegalArgumentException("No Cygnus datatype registered for " + item.getClass());
        }
        nbt.func_74778_a("Type", ((ResourceLocation)typesByResourceLocation.inverse().get((Object)datatype)).toString());
        datatype.writeToNBT(nbt, item);
    }

    public static Object readFromNBT(NBTTagCompound nbt) {
        ResourceLocation type = new ResourceLocation(nbt.func_74779_i("Type"));
        ICygnusDatatype datatype = (ICygnusDatatype)typesByResourceLocation.get((Object)type);
        if (datatype == null) {
            Incorporeal.LOGGER.warn("Couldn't find a Cygnus datatype to deserialize " + type + ", maybe the mod was removed? Replacing it with a CygnusError");
            return new CygnusError("incorporeal.cygnus.error.removed_type");
        }
        return datatype.readFromNBT(nbt);
    }

    public static <T> void writeToPacketBuffer(PacketBuffer buf, T item) {
        ICygnusDatatype datatype = (ICygnusDatatype)typesByClass.get(item.getClass());
        if (datatype == null) {
            throw new IllegalArgumentException("No Cygnus datatype registered for " + item.getClass());
        }
        buf.writeInt(((Integer)typesByNetworkID.inverse().get((Object)datatype)).intValue());
        datatype.writeToPacketBuffer(buf, item);
    }

    public static Object readFromPacketBuffer(PacketBuffer buf) {
        return ((ICygnusDatatype)typesByNetworkID.get((Object)buf.readInt())).readFromPacketBuffer(buf);
    }
}

