/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.minecraft.util.text.translation.I18n;

public class CygnusError {
    public static final int MAX_KEY_LENGTH = 256;
    public static final String UNSPECIFIED = "incorporeal.cygnus.error.unspecified";
    public static final String UNDERFLOW = "incorporeal.cygnus.error.stack_underflow";
    public static final String MISMATCH = "incorporeal.cygnus.error.mismatched_type";
    public static final String OUT_OF_RANGE = "incorporeal.cygnus.error.out_of_range";
    public static final String INVALID_MATH = "incorporeal.cygnus.error.invalid_math";
    public static final String REMOVED_TYPE = "incorporeal.cygnus.error.removed_type";
    public final String errorTranslationKey;
    public final String[] errorFormat;

    public CygnusError() {
        this(UNSPECIFIED);
    }

    public CygnusError(String errorTranslationKey) {
        this(errorTranslationKey.isEmpty() ? UNSPECIFIED : errorTranslationKey, new String[0]);
    }

    public CygnusError(String errorTranslationKey, String ... errorFormat) {
        Preconditions.checkArgument((errorTranslationKey.length() <= 256 ? 1 : 0) != 0, (Object)"Too long translation key!");
        for (String s : errorFormat) {
            Preconditions.checkArgument((s.length() <= 256 ? 1 : 0) != 0, (Object)"Too long format argument!");
        }
        this.errorTranslationKey = errorTranslationKey;
        this.errorFormat = errorFormat;
    }

    public String getTranslatedText() {
        return I18n.func_74837_a((String)this.errorTranslationKey, (Object[])Arrays.stream(this.errorFormat).map(I18n::func_74838_a).toArray());
    }

    public String toString() {
        return this.getTranslatedText();
    }
}

