/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;

public class CygnusStack
implements ICygnusStack {
    private int maxDepth;
    private Object[] stack;
    private int cursor = 0;
    boolean dirty = false;

    public CygnusStack(int maxDepth) {
        this.maxDepth = maxDepth;
        this.clear();
    }

    @Override
    public <T> void push(@Nonnull T item) {
        if (this.cursor == this.maxDepth) {
            return;
        }
        Preconditions.checkNotNull(item);
        ICygnusDatatype<?> datatype = CygnusDatatypeHelpers.forClass(item.getClass());
        Object error = datatype.getError(item, this);
        if (error == null) {
            this.stack[this.cursor] = item;
            ++this.cursor;
            this.dirty = true;
        } else {
            this.push(error);
        }
    }

    @Override
    public Optional<Object> pop() {
        if (this.cursor == 0) {
            return Optional.empty();
        }
        --this.cursor;
        Object removedObject = this.stack[this.cursor];
        this.stack[this.cursor] = null;
        this.dirty = true;
        return Optional.of(removedObject);
    }

    @Override
    public void popDestroy(int popDepth) {
        if (this.cursor < popDepth) {
            throw new IllegalStateException("Stack underflow using popDestroy - programmer error");
        }
        if (popDepth == 0) {
            return;
        }
        for (int i = 0; i < popDepth; ++i) {
            --this.cursor;
            this.stack[this.cursor] = null;
        }
        this.dirty = true;
    }

    @Override
    public Optional<Object> peek() {
        return this.peek(0);
    }

    @Override
    public Optional<Object> peek(int peekDepth) {
        if (this.cursor - peekDepth - 1 < 0) {
            return Optional.empty();
        }
        this.dirty = true;
        return Optional.of(this.stack[this.cursor - peekDepth - 1]);
    }

    @Override
    public <T> Optional<T> peekMatching(Class<T> matchingClass) {
        return this.peekMatching(matchingClass, 0);
    }

    @Override
    public <T> Optional<T> peekMatching(Class<T> matchingClass, int peekDepth) {
        return this.peek(peekDepth).filter(o -> o.getClass().equals(matchingClass));
    }

    @Override
    public int depth() {
        return this.cursor;
    }

    @Override
    public boolean isEmpty() {
        return this.cursor == 0;
    }

    @Override
    public boolean isFull() {
        return this.cursor == this.maxDepth;
    }

    @Override
    public int maxDepth() {
        return this.maxDepth;
    }

    @Override
    public void clear() {
        this.cursor = 0;
        this.stack = new Object[this.maxDepth];
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }

    @Override
    public CygnusStack copy() {
        CygnusStack other = new CygnusStack(this.maxDepth);
        for (int i = 0; i < this.cursor; ++i) {
            other.push(this.stack[i]);
        }
        return other;
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74768_a("MaxDepth", this.maxDepth);
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < this.cursor; ++i) {
            NBTTagCompound entry = new NBTTagCompound();
            CygnusDatatypeHelpers.writeToNBT(entry, this.stack[i]);
            nbtList.func_74742_a((NBTBase)entry);
        }
        ret.func_74782_a("Stack", (NBTBase)nbtList);
        return ret;
    }

    @Override
    public void fromNBT(NBTTagCompound nbt) {
        this.maxDepth = nbt.func_74762_e("MaxDepth");
        this.clear();
        NBTTagList nbtList = nbt.func_150295_c("Stack", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound entry = nbtList.func_150305_b(i);
            this.stack[i] = CygnusDatatypeHelpers.readFromNBT(entry);
        }
        this.cursor = nbtList.func_74745_c();
    }

    @Override
    public void toPacketBuffer(PacketBuffer buf) {
        buf.writeInt(this.maxDepth);
        buf.writeInt(this.cursor);
        for (int i = 0; i < this.cursor; ++i) {
            CygnusDatatypeHelpers.writeToPacketBuffer(buf, this.stack[i]);
        }
    }

    @Override
    public void fromPacketBuffer(PacketBuffer buf) {
        this.maxDepth = buf.readInt();
        this.clear();
        int stackAmount = buf.readInt();
        for (int i = 0; i < stackAmount; ++i) {
            this.stack[i] = CygnusDatatypeHelpers.readFromPacketBuffer(buf);
        }
    }
}

