/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.ISimpleRegistry;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.CygnusError;

public final class IncorporeticCygnusConditions {
    public static Predicate<ICygnusStack> NOTHING;

    private IncorporeticCygnusConditions() {
    }

    public static void registerCygnusConditions() {
        ISimpleRegistry<Predicate<ICygnusStack>> reg = Incorporeal.API.getCygnusStackConditionRegistry();
        NOTHING = stack -> false;
        reg.register(new ResourceLocation("incorporeal", "nothing"), NOTHING);
        reg.register(new ResourceLocation("incorporeal", "empty_stack"), ICygnusStack::isEmpty);
        reg.register(new ResourceLocation("incorporeal", "full_stack"), ICygnusStack::isFull);
        reg.register(new ResourceLocation("incorporeal", "equal_value"), stack -> {
            Optional<Object> top = stack.peek(0);
            Optional<Object> under = stack.peek(1);
            if (top.isPresent() && under.isPresent()) {
                Object thingTop = top.get();
                Object thingUnder = under.get();
                if (thingTop.getClass() != thingUnder.getClass()) {
                    return false;
                }
                return CygnusDatatypeHelpers.forClass(thingTop.getClass()).areEqualUnchecked(thingTop, thingUnder);
            }
            return false;
        });
        reg.register(new ResourceLocation("incorporeal", "equal_type"), stack -> {
            Optional<Object> top = stack.peek(0);
            Optional<Object> under = stack.peek(1);
            if (top.isPresent() && under.isPresent()) {
                return top.get().getClass() == under.get().getClass();
            }
            return false;
        });
        reg.register(new ResourceLocation("incorporeal", "less_than"), stack -> IncorporeticCygnusConditions.compareTopTwo(stack) < 0);
        reg.register(new ResourceLocation("incorporeal", "greater_than"), stack -> IncorporeticCygnusConditions.compareTopTwo(stack) > 0);
        reg.register(new ResourceLocation("incorporeal", "errored"), stack -> stack.peekMatching(CygnusError.class).isPresent());
    }

    private static int compareTopTwo(ICygnusStack stack) {
        Optional<Object> top = stack.peek(0);
        Optional<Object> under = stack.peek(1);
        if (top.isPresent() && under.isPresent()) {
            Object thingTop = top.get();
            Object thingUnder = under.get();
            if (thingTop.getClass() != thingUnder.getClass()) {
                return 0;
            }
            ICygnusDatatype<?> type = CygnusDatatypeHelpers.forClass(thingTop.getClass());
            if (!type.canCompare()) {
                return 0;
            }
            return type.compareUnchecked(thingTop, thingUnder);
        }
        return 0;
    }
}

