/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus.types;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.etc.helper.CorporeaHelper2;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequest;

public class CygnusCorporeaRequestType
implements ICygnusDatatype<CorporeaRequest> {
    @Override
    public Class<CorporeaRequest> getTypeClass() {
        return CorporeaRequest.class;
    }

    @Override
    public String getTranslationKey() {
        return "incorporeal.cygnus.type.corporea_request";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> describe(CorporeaRequest thing) {
        StringBuilder b = new StringBuilder();
        if (thing.matcher instanceof ItemStack) {
            b.append(TextFormatting.AQUA);
        } else {
            b.append(TextFormatting.ITALIC);
        }
        b.append("\"");
        b.append(this.toString(thing));
        b.append("\"");
        b.append(TextFormatting.RESET);
        return ImmutableList.of((Object)b.toString());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, CorporeaRequest item) {
        nbt.func_74757_a("Strict", item.checkNBT);
        nbt.func_74768_a("Count", item.count);
        if (item.matcher instanceof ItemStack) {
            nbt.func_74782_a("ItemStack", (NBTBase)((ItemStack)item.matcher).serializeNBT());
        } else if (item.matcher instanceof String) {
            nbt.func_74778_a("String", (String)item.matcher);
        } else {
            throw new IllegalArgumentException("CorporeaRequest containing something not an itemstack or a string?");
        }
    }

    @Override
    public CorporeaRequest readFromNBT(NBTTagCompound nbt) {
        boolean strict = nbt.func_74767_n("Strict");
        int count = nbt.func_74762_e("Count");
        if (nbt.func_74764_b("ItemStack")) {
            return new CorporeaRequest((Object)new ItemStack(nbt.func_74775_l("ItemStack")), strict, count);
        }
        if (nbt.func_74764_b("String")) {
            return new CorporeaRequest((Object)nbt.func_74779_i("String"), strict, count);
        }
        Incorporeal.LOGGER.error("Tried to deserialize CorporeaRequest without an ItemStack or String. Defaulting to empty request");
        return new CorporeaRequest((Object)ItemStack.field_190927_a, false, 0);
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer buf, CorporeaRequest item) {
        buf.writeBoolean(item.checkNBT);
        buf.writeInt(item.count);
        if (item.matcher instanceof ItemStack) {
            buf.writeBoolean(true);
            buf.func_150788_a((ItemStack)item.matcher);
        } else if (item.matcher instanceof String) {
            buf.writeBoolean(false);
            buf.func_180714_a((String)item.matcher);
        } else {
            throw new IllegalArgumentException("CorporeaRequest containing something not an itemstack or a string?");
        }
    }

    @Override
    public CorporeaRequest readFromPacketBuffer(PacketBuffer buf) {
        boolean strict = buf.readBoolean();
        int count = buf.readInt();
        boolean isStack = buf.readBoolean();
        if (isStack) {
            try {
                return new CorporeaRequest((Object)buf.func_150791_c(), strict, count);
            }
            catch (IOException e) {
                Incorporeal.LOGGER.error("Problem deserializing CorporeaRequest from packet, defaulting to empty one ", (Throwable)e);
                return new CorporeaRequest((Object)ItemStack.field_190927_a, false, 0);
            }
        }
        return new CorporeaRequest((Object)buf.func_150789_c(Short.MAX_VALUE), strict, count);
    }

    @Override
    public boolean areEqual(CorporeaRequest item1, CorporeaRequest item2) {
        if (item1.count != item2.count) {
            return false;
        }
        if (item1.matcher instanceof ItemStack && item2.matcher instanceof ItemStack) {
            return ItemStack.func_77989_b((ItemStack)((ItemStack)item1.matcher), (ItemStack)((ItemStack)item2.matcher));
        }
        if (item1.matcher instanceof String && item2.matcher instanceof String) {
            return item1.matcher.equals(item2.matcher);
        }
        if (item1.matcher instanceof ItemStack && item2.matcher instanceof String) {
            return ((ItemStack)item1.matcher).func_82833_r().equalsIgnoreCase((String)item2.matcher);
        }
        if (item1.matcher instanceof String && item2.matcher instanceof ItemStack) {
            return ((ItemStack)item2.matcher).func_82833_r().equalsIgnoreCase((String)item1.matcher);
        }
        return false;
    }

    @Override
    public boolean canCompare() {
        return true;
    }

    @Override
    public int compare(CorporeaRequest item1, CorporeaRequest item2) {
        return Integer.compare(item1.count, item2.count);
    }

    @Override
    public String toString(CorporeaRequest item) {
        return CorporeaHelper2.requestToString(item);
    }

    @Override
    public int toComparator(CorporeaRequest item) {
        int x = CorporeaHelper.signalStrengthForRequestSize((int)item.count);
        return x == 0 ? 1 : x;
    }
}

