/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus.types;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.cygnus.CygnusError;

public class CygnusErrorType
implements ICygnusDatatype<CygnusError> {
    @Override
    public Class<CygnusError> getTypeClass() {
        return CygnusError.class;
    }

    @Override
    public String getTranslationKey() {
        return "incorporeal.cygnus.type.error";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> describe(CygnusError thing) {
        return ImmutableList.of((Object)(TextFormatting.RED + this.toString(thing)));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, CygnusError item) {
        nbt.func_74778_a("ErrorMessage", item.errorTranslationKey);
        if (item.errorFormat.length > 0) {
            NBTTagList formatList = new NBTTagList();
            for (String s : item.errorFormat) {
                formatList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            nbt.func_74782_a("ErrorParams", (NBTBase)formatList);
        }
    }

    @Override
    public CygnusError readFromNBT(NBTTagCompound nbt) {
        String message = nbt.func_74779_i("ErrorMessage");
        if (nbt.func_74764_b("ErrorParams")) {
            NBTTagList formatList = nbt.func_150295_c("ErrorParams", 8);
            String[] formats = new String[formatList.func_74745_c()];
            for (int i = 0; i < formatList.func_74745_c(); ++i) {
                formats[i] = formatList.func_150307_f(i);
            }
            return new CygnusError(message, formats);
        }
        return new CygnusError(message);
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer buf, CygnusError item) {
        buf.func_180714_a(item.errorTranslationKey);
        buf.writeInt(item.errorFormat.length);
        for (String s : item.errorFormat) {
            buf.func_180714_a(s);
        }
    }

    @Override
    public CygnusError readFromPacketBuffer(PacketBuffer buf) {
        String key = buf.func_150789_c(256);
        int formatArguments = buf.readInt();
        if (formatArguments == 0) {
            return new CygnusError(key);
        }
        String[] formats = new String[formatArguments];
        for (int i = 0; i < formatArguments; ++i) {
            formats[i] = buf.func_150789_c(256);
        }
        return new CygnusError(key, formats);
    }

    @Override
    public boolean areEqual(CygnusError item1, CygnusError item2) {
        return item1.errorTranslationKey.equals(item2.errorTranslationKey) && Arrays.deepEquals(item1.errorFormat, item2.errorFormat);
    }
}

