/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class BiOptional<A, B> {
    private final A a;
    private final B b;

    private BiOptional(A a, B b) {
        this.a = a;
        this.b = b;
    }

    private BiOptional() {
        this(null, null);
    }

    public static <A, B> BiOptional<A, B> of(A a, B b) {
        return new BiOptional<A, B>(a, b);
    }

    public static <A, B> BiOptional<A, B> empty() {
        return new BiOptional<A, B>();
    }

    public static <A, B> BiOptional<A, B> ofFirst(A a) {
        return new BiOptional<A, Object>(a, null);
    }

    public static <A, B> BiOptional<A, B> ofSecond(B b) {
        return new BiOptional<Object, B>(null, b);
    }

    public BiOptional<A, B> ifBothPresent(BiConsumer<A, B> func) {
        if (this.a != null && this.b != null) {
            func.accept(this.a, this.b);
        }
        return this;
    }

    public BiOptional<A, B> ifFirstPresent(Consumer<A> func) {
        if (this.a != null) {
            func.accept(this.a);
        }
        return this;
    }

    public BiOptional<A, B> ifSecondPresent(Consumer<B> func) {
        if (this.b != null) {
            func.accept(this.b);
        }
        return this;
    }

    public BiOptional<A, B> ifFirstNotPresent(Runnable func) {
        if (this.a == null) {
            func.run();
        }
        return this;
    }

    public BiOptional<A, B> ifSecondNotPresent(Runnable func) {
        if (this.b == null) {
            func.run();
        }
        return this;
    }

    public BiOptional<A, B> ifEitherPresent(Runnable func) {
        if (this.a != null || this.b != null) {
            func.run();
        }
        return this;
    }

    public BiOptional<A, B> ifNeitherPresent(Runnable func) {
        if (this.a == null && this.b == null) {
            func.run();
        }
        return this;
    }

    public BiOptional<A, B> ifEitherNotPresent(Runnable func) {
        if (this.a == null || this.b == null) {
            func.run();
        }
        return this;
    }

    public Optional<A> first() {
        return Optional.ofNullable(this.a);
    }

    public Optional<B> second() {
        return Optional.ofNullable(this.b);
    }

    public A getFirst() {
        if (this.a == null) {
            throw new NullPointerException();
        }
        return this.a;
    }

    public B getSecond() {
        if (this.b == null) {
            throw new NullPointerException();
        }
        return this.b;
    }

    @Nullable
    public A getFirstNullable() {
        return this.a;
    }

    @Nullable
    public B getSecondNullable() {
        return this.b;
    }

    public boolean hasFirst() {
        return this.a != null;
    }

    public boolean hasSecond() {
        return this.b != null;
    }

    public boolean hasBoth() {
        return this.a != null && this.b != null;
    }
}

