/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import quaternary.incorporeal.api.ISimpleRegistry;

public class SimpleRegistry<T>
implements ISimpleRegistry<T> {
    private BiMap<ResourceLocation, T> registry = HashBiMap.create();
    private List<T> valuesOrdered = new LinkedList<T>();
    private boolean frozen = false;

    @Override
    public void register(ResourceLocation name, T item) {
        if (this.frozen) {
            throw new IllegalStateException("Too late, this registry is frozen");
        }
        this.registry.put((Object)name, item);
        this.valuesOrdered.add(item);
    }

    @Override
    public T get(ResourceLocation name) {
        return (T)this.registry.get((Object)name);
    }

    @Override
    public ResourceLocation nameOf(T item) {
        return (ResourceLocation)this.registry.inverse().get(item);
    }

    @Override
    public Set<ResourceLocation> allKeys() {
        return this.registry.keySet();
    }

    @Override
    public Set<T> allValues() {
        return this.registry.values();
    }

    @Override
    public BiMap<ResourceLocation, T> backingMap() {
        return this.registry;
    }

    @Override
    public T next(T cur) {
        if (cur == null) {
            return this.valuesOrdered.get(0);
        }
        int i = this.indexOf(cur) + 1;
        if (i == this.valuesOrdered.size()) {
            i = 0;
        }
        return this.valuesOrdered.get(i);
    }

    @Override
    public T prev(T cur) {
        if (cur == null) {
            return this.valuesOrdered.get(0);
        }
        int i = this.indexOf(cur) - 1;
        if (i == -1) {
            i = this.valuesOrdered.size() - 1;
        }
        return this.valuesOrdered.get(i);
    }

    private int indexOf(T thing) {
        Iterator<T> it = this.valuesOrdered.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (thing.equals(it.next())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void freeze() {
        this.frozen = true;
    }
}

