/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc.event;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quaternary.incorporeal.api.recipe.IRecipeSkytouching;
import quaternary.incorporeal.block.IncorporeticBlocks;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.net.IncorporeticPacketHandler;
import quaternary.incorporeal.net.MessageSkytouchingEffect;
import quaternary.incorporeal.recipe.skytouch.IncorporeticSkytouchingRecipes;
import vazkii.botania.common.item.ModItems;

@Mod.EventBusSubscriber(modid="incorporeal")
public final class CommonGameEvents {
    private CommonGameEvents() {
    }

    @SubscribeEvent
    public static void plantRedstoneRoot(PlayerInteractEvent.RightClickBlock e) {
        ItemStack stack = e.getItemStack();
        if (stack.func_77973_b() == ModItems.manaResource && stack.func_77960_j() == 6) {
            BlockPos pos;
            EnumFacing facing = e.getFace();
            if (facing != EnumFacing.UP) {
                return;
            }
            World world = e.getWorld();
            if (!world.func_175623_d((pos = e.getPos()).func_177984_a())) {
                return;
            }
            EntityPlayer player = e.getEntityPlayer();
            IBlockState farmlandState = world.func_180495_p(pos);
            if (player.func_175151_a(pos.func_177972_a(facing), facing, stack) && farmlandState.func_177230_c().canSustainPlant(farmlandState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)IncorporeticBlocks.REDSTONE_ROOT_CROP)) {
                world.func_175656_a(pos.func_177984_a(), IncorporeticBlocks.REDSTONE_ROOT_CROP.func_176223_P());
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), stack);
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                player.func_184609_a(e.getHand());
            }
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        World world = e.world;
        if (world.field_72995_K) {
            return;
        }
        List items = world.func_175644_a(EntityItem.class, i -> i != null && !i.field_70128_L && i.field_70167_r >= (double)IncorporeticSkytouchingRecipes.LOWEST_SKYTOUCH_Y && i.field_70163_u < i.field_70167_r);
        block0: for (EntityItem ent : items) {
            for (IRecipeSkytouching recipe : IncorporeticSkytouchingRecipes.ALL) {
                if (!recipe.matches(ent)) continue;
                for (ItemStack out : recipe.getOutputs(ent)) {
                    world.func_72838_d((Entity)new EntityItem(world, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, out));
                }
                IncorporeticPacketHandler.sendToAllTracking(new MessageSkytouchingEffect(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v), world, ent.func_180425_c());
                ent.func_70106_y();
                continue block0;
            }
        }
    }

    @SubscribeEvent
    public static void missingBlocks(RegistryEvent.MissingMappings<Block> e) {
        for (RegistryEvent.MissingMappings.Mapping map : e.getMappings()) {
            if (!map.key.func_110623_a().equals("corporea_liar")) continue;
            map.remap((IForgeRegistryEntry)IncorporeticBlocks.RED_STRING_LIAR);
        }
    }

    @SubscribeEvent
    public static void missingItems(RegistryEvent.MissingMappings<Item> e) {
        for (RegistryEvent.MissingMappings.Mapping map : e.getMappings()) {
            if (!map.key.func_110623_a().equals("corporea_liar")) continue;
            map.remap((IForgeRegistryEntry)IncorporeticItems.RED_STRING_LIAR);
        }
    }
}

