/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc.helper;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;
import vazkii.botania.common.entity.EntityCorporeaSpark;

public final class CorporeaHelper2 {
    private CorporeaHelper2() {
    }

    public static EntityCorporeaSpark getSparkEntityForBlock(World world, BlockPos pos) {
        List sparks = world.func_72872_a(EntityCorporeaSpark.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)));
        return sparks.isEmpty() ? null : (EntityCorporeaSpark)sparks.get(0);
    }

    public static List<TileCorporeaIndex> getNearbyIndicesReflect(World w, BlockPos pos, int range) {
        Set indices = (Set)ReflectionHelper.getPrivateValue(TileCorporeaIndex.class, null, (String[])new String[]{"serverIndexes"});
        return indices.stream().filter(tile -> {
            if (tile.func_145831_w().field_73011_w.getDimension() != w.field_73011_w.getDimension()) {
                return false;
            }
            return Math.abs(pos.func_177958_n() - tile.func_174877_v().func_177958_n()) <= range && Math.abs(pos.func_177952_p() - tile.func_174877_v().func_177952_p()) <= range && tile.func_174877_v().func_177956_o() == pos.func_177956_o();
        }).collect(Collectors.toList());
    }

    public static void spawnRequest(World w, CorporeaRequest request, ICorporeaSpark spork, Vec3d spawningPos) {
        if (spork == null) {
            return;
        }
        List stacks = CorporeaHelper.requestItem((Object)request.matcher, (int)request.count, (ICorporeaSpark)spork, (boolean)request.checkNBT, (boolean)true);
        spork.onItemsRequested(stacks);
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            EntityItem ent = new EntityItem(w);
            ent.func_92058_a(stack);
            ent.func_70107_b(spawningPos.field_72450_a, spawningPos.field_72448_b, spawningPos.field_72449_c);
            w.func_72838_d((Entity)ent);
        }
    }

    public static void spawnRequest(World w, CorporeaRequest request, ICorporeaSpark spork, BlockPos spawningPos) {
        CorporeaHelper2.spawnRequest(w, request, spork, new Vec3d((double)spawningPos.func_177958_n() + 0.5, (double)spawningPos.func_177956_o() + 1.5, (double)spawningPos.func_177952_p() + 0.5));
    }

    public static String requestToString(CorporeaRequest request) {
        String count;
        boolean pluralize = false;
        String item = request.matcher instanceof ItemStack ? ((ItemStack)request.matcher).func_82833_r().toLowerCase() : request.matcher.toString();
        if (request.count == 0) {
            count = "0 ";
        } else if (request.count == 1) {
            count = "";
        } else if (request.count == 64) {
            count = "a stack of ";
        } else if (request.count % 64 == 0) {
            count = request.count / 64 + " stacks of ";
        } else if (request.count == Integer.MAX_VALUE) {
            count = "all ";
            pluralize = true;
        } else {
            count = String.valueOf(request.count) + " ";
            pluralize = true;
        }
        if (item.charAt(item.length() - 1) == 's') {
            pluralize = false;
        }
        return count + item + (pluralize ? "s" : "");
    }

    public static void causeSparkRelink(EntityCorporeaSpark spork) {
        try {
            ReflectionHelper.setPrivateValue(EntityCorporeaSpark.class, (Object)spork, null, (String[])new String[]{"master"});
            ReflectionHelper.setPrivateValue(EntityCorporeaSpark.class, (Object)spork, (Object)true, (String[])new String[]{"firstTick"});
            ReflectionHelper.findMethod(EntityCorporeaSpark.class, (String)"restartNetwork", null, (Class[])new Class[0]).invoke((Object)spork, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException oof) {
            throw new RuntimeException("There was a problem doing hacky reflective access on a spark!", oof);
        }
    }

    public static CorporeaRequest copyCorporeaRequest(CorporeaRequest request) {
        return new CorporeaRequest(request.matcher, request.checkNBT, request.count);
    }

    public static CorporeaRequest getCorporeaRequestInRetainer(TileCorporeaRetainer retainer) {
        try {
            Object matcher = ReflectionHelper.getPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (String[])new String[]{"request"});
            if (matcher == null) {
                return null;
            }
            return new CorporeaRequest(matcher, false, ((Integer)ReflectionHelper.getPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (String[])new String[]{"requestCount"})).intValue());
        }
        catch (RuntimeException oof) {
            throw new RuntimeException("There was a problem doing hacky reflective access on a corporea retainer!", oof);
        }
    }

    public static void setCorporeaRequestInRetainer(TileCorporeaRetainer retainer, CorporeaRequest request) {
        try {
            CorporeaHelper2.clearRetainer(retainer);
            retainer.setPendingRequest((BlockPos)ReflectionHelper.getPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (String[])new String[]{"requestPos"}), request.matcher, request.count);
        }
        catch (RuntimeException oof) {
            throw new RuntimeException("There was a problem doing hacky reflective access on a corporea retainer!", oof);
        }
    }

    public static void clearRetainer(TileCorporeaRetainer retainer) {
        try {
            ReflectionHelper.setPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (Object)false, (String[])new String[]{"pendingRequest"});
            ReflectionHelper.setPrivateValue(TileCorporeaRetainer.class, (Object)retainer, (Object)0, (String[])new String[]{"compValue"});
            ReflectionHelper.setPrivateValue(TileCorporeaRetainer.class, (Object)retainer, null, (String[])new String[]{"request"});
            retainer.func_145831_w().func_175666_e(retainer.func_174877_v(), retainer.func_145838_q());
        }
        catch (RuntimeException oof) {
            throw new RuntimeException("There was a problem doing hacky reflective access on a corporea retainer!", oof);
        }
    }
}

