/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.flower;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import quaternary.incorporeal.flower.IncorporeticSubTileSignature;
import quaternary.incorporeal.flower.SubTileSanvocalia;
import quaternary.incorporeal.flower.SubTileSweetAlexum;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public final class IncorporeticFlowers {
    private static final List<String> moddedFlowers = new ArrayList<String>();

    private IncorporeticFlowers() {
    }

    public static void registerFlowers() {
        IncorporeticFlowers.registerFlower("sanvocalia", SubTileSanvocalia.class, SubTileSanvocalia.Mini.class);
        IncorporeticFlowers.registerFlower("sweet_alexum", SubTileSweetAlexum.class, SubTileSweetAlexum.Mini.class);
    }

    public static List<ItemStack> getAllIncorporeticFlowerStacks() {
        ArrayList<ItemStack> memes = new ArrayList<ItemStack>();
        for (String a : moddedFlowers) {
            memes.add(ItemBlockSpecialFlower.ofType((String)a));
        }
        for (String a : moddedFlowers) {
            memes.add(ItemBlockSpecialFlower.ofType((ItemStack)new ItemStack(ModBlocks.floatingSpecialFlower), (String)a));
        }
        return memes;
    }

    private static void registerFlower(String normalName, Class<? extends SubTileEntity> normalClass, Class<? extends SubTileEntity> smolClass) {
        String smolName = normalName + "_chibi";
        BotaniaAPI.registerSubTile((String)normalName, normalClass);
        BotaniaAPI.registerMiniSubTile((String)smolName, smolClass, (String)normalName);
        BotaniaAPI.registerSubTileSignature(normalClass, (SubTileSignature)new IncorporeticSubTileSignature(normalName));
        BotaniaAPI.registerSubTileSignature(smolClass, (SubTileSignature)new IncorporeticSubTileSignature(smolName));
        moddedFlowers.add(normalName);
        moddedFlowers.add(smolName);
        BotaniaAPI.addSubTileToCreativeMenu((String)normalName);
    }
}

