/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.flower;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.etc.helper.DespacitoHelper;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import quaternary.incorporeal.net.IncorporeticPacketHandler;
import quaternary.incorporeal.net.MessageSparkleLine;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;

public class SubTileSweetAlexum
extends SubTileFunctional
implements ILexiconable {
    private int ticksPaused = 0;
    private int ticksSinceReset = 0;

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        this.ticksSinceReset = (int)world.func_82737_E();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.redstoneSignal == 15) {
            this.resetTime();
        } else if (this.redstoneSignal > 0 || this.mana < 100) {
            ++this.ticksPaused;
        } else {
            int[] notes;
            World world = this.getWorld();
            int tick = (int)(world.func_82737_E() - (long)this.ticksSinceReset - (long)this.ticksPaused - 1L);
            if (tick < 0 || tick % this.getTicksBetweenNotes() != 0) {
                return;
            }
            tick /= this.getTicksBetweenNotes();
            BlockPos flutePos = null;
            BlockPos snarePos = null;
            BlockPos bassdrumPos = null;
            BlockPos bassguitarPos = null;
            BlockPos pos = this.getPos();
            int range = this.getRange();
            for (BlockPos bp : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, 0, -range), (BlockPos)pos.func_177982_a(range, 1, range))) {
                if (world.func_180495_p(bp).func_177230_c() != Blocks.field_150323_B) continue;
                NoteBlockEvent.Instrument instUnder = DespacitoHelper.getInstrumentFromState(world.func_180495_p(bp.func_177977_b()));
                if (instUnder == NoteBlockEvent.Instrument.FLUTE && flutePos == null) {
                    flutePos = bp.func_185334_h();
                    continue;
                }
                if (instUnder == NoteBlockEvent.Instrument.SNARE && snarePos == null) {
                    snarePos = bp.func_185334_h();
                    continue;
                }
                if (instUnder == NoteBlockEvent.Instrument.BASSDRUM && bassdrumPos == null) {
                    bassdrumPos = bp.func_185334_h();
                    continue;
                }
                if (instUnder != NoteBlockEvent.Instrument.BASSGUITAR || bassguitarPos != null) continue;
                bassguitarPos = bp.func_185334_h();
            }
            boolean dirtyMana = false;
            if (flutePos != null && (notes = DespacitoHelper.getNotesForTick(tick, NoteBlockEvent.Instrument.FLUTE)).length > 0) {
                IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine((Vec3i)pos, (Vec3i)flutePos, 1), world, pos);
                for (int note : notes) {
                    world.func_175641_c(flutePos, Blocks.field_150323_B, NoteBlockEvent.Instrument.FLUTE.ordinal(), note);
                    this.mana -= 10;
                    dirtyMana = true;
                }
            }
            if (snarePos != null && (notes = DespacitoHelper.getNotesForTick(tick, NoteBlockEvent.Instrument.SNARE)).length > 0) {
                IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine((Vec3i)pos, (Vec3i)snarePos, 2), world, pos);
                for (int note : notes) {
                    world.func_175641_c(snarePos, Blocks.field_150323_B, NoteBlockEvent.Instrument.SNARE.ordinal(), note);
                    this.mana -= 10;
                    dirtyMana = true;
                }
            }
            if (bassdrumPos != null && (notes = DespacitoHelper.getNotesForTick(tick, NoteBlockEvent.Instrument.BASSDRUM)).length > 0) {
                IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine((Vec3i)pos, (Vec3i)bassdrumPos, 2), world, pos);
                for (int note : notes) {
                    world.func_175641_c(bassdrumPos, Blocks.field_150323_B, NoteBlockEvent.Instrument.BASSDRUM.ordinal(), note);
                    this.mana -= 10;
                    dirtyMana = true;
                }
            }
            if (bassguitarPos != null && (notes = DespacitoHelper.getNotesForTick(tick, NoteBlockEvent.Instrument.BASSGUITAR)).length > 0) {
                IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine((Vec3i)pos, (Vec3i)bassguitarPos, 2), world, pos);
                for (int note : notes) {
                    world.func_175641_c(bassguitarPos, Blocks.field_150323_B, NoteBlockEvent.Instrument.BASSGUITAR.ordinal(), note);
                    this.mana -= 10;
                    dirtyMana = true;
                }
            }
            if (dirtyMana) {
                this.sync();
            }
        }
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public int getMaxMana() {
        return 2000;
    }

    public int getColor() {
        return 0xBB4422;
    }

    private void resetTime() {
        this.ticksSinceReset = (int)this.getWorld().func_82737_E();
        this.ticksPaused = 0;
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a("LastResetTicks", this.ticksSinceReset);
        cmp.func_74768_a("PausedTicks", this.ticksPaused);
        super.writeToPacketNBT(cmp);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.ticksSinceReset = cmp.func_74762_e("LastResetTicks");
        this.ticksPaused = cmp.func_74762_e("PausedTicks");
    }

    protected int getRange() {
        return 4;
    }

    protected int getTicksBetweenNotes() {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getPos(), this.getRange());
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.sweetAlexum;
    }

    public static class Mini
    extends SubTileSweetAlexum {
        @Override
        protected int getRange() {
            return 1;
        }

        @Override
        protected int getTicksBetweenNotes() {
            return 3;
        }
    }
}

