/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

public class ItemCorporeaTicket
extends Item
implements ILexiconable {
    public ItemCorporeaTicket() {
        this.func_185043_a(new ResourceLocation("incorporeal", "written_ticket"), (stack, world, entity) -> ItemCorporeaTicket.hasRequest(stack) ? 1.0f : 0.0f);
    }

    public static ItemStack createFromRequest(Object request, int requestedCount) {
        ItemStack stack = new ItemStack((Item)IncorporeticItems.CORPOREA_TICKET);
        stack.func_77983_a("RequestAmount", (NBTBase)new NBTTagInt(requestedCount));
        if (request instanceof ItemStack) {
            stack.func_77983_a("RequestItem", (NBTBase)((ItemStack)request).func_77955_b(new NBTTagCompound()));
        } else if (request instanceof String) {
            stack.func_77983_a("RequestString", (NBTBase)new NBTTagString((String)request));
        } else {
            throw new IllegalArgumentException("Corporea request not a String or ItemStack?????????");
        }
        return stack;
    }

    public static CorporeaRequest getRequest(ItemStack ticket) {
        if (ticket.func_190926_b()) {
            return null;
        }
        NBTTagCompound cmp = ticket.func_77978_p();
        if (cmp != null && cmp.func_74764_b("RequestAmount")) {
            int count = cmp.func_74762_e("RequestAmount");
            String request = cmp.func_74764_b("RequestItem") ? new ItemStack(cmp.func_74775_l("RequestItem")) : cmp.func_74779_i("RequestString");
            return new CorporeaRequest((Object)request, true, count);
        }
        return null;
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound cmp = stack.func_77978_p();
        if (cmp != null && cmp.func_74764_b("RequestAmount")) {
            String requestName;
            int count = cmp.func_74762_e("RequestAmount");
            if (cmp.func_74764_b("RequestItem")) {
                ItemStack storedStack = new ItemStack(cmp.func_74775_l("RequestItem"));
                requestName = storedStack.func_82833_r();
            } else {
                requestName = cmp.func_74779_i("RequestString");
            }
            requestName = WordUtils.capitalizeFully((String)requestName).trim();
            return I18n.func_74837_a((String)"item.incorporeal.filled_corporea_ticket.name", (Object[])new Object[]{count, requestName}).trim();
        }
        return super.func_77653_i(stack);
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.corporeaSolidifier;
    }

    public static boolean hasRequest(ItemStack stack) {
        return ItemCorporeaTicket.getRequest(stack) != null;
    }
}

