/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.entity.EntityFracturedSpaceCollector;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.block.BlockOpenCrate;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemFracturedSpaceRod
extends Item
implements IManaUsingItem,
ILexiconable,
ICoordBoundItem {
    public static final String CRATE_POS_KEY = "CratePos";
    public static final String CRATE_DIMENSION_KEY = "CrateDimension";

    public ItemFracturedSpaceRod() {
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        IBlockState hitState = world.func_180495_p(pos);
        Block hitBlock = hitState.func_177230_c();
        if (hitBlock instanceof BlockOpenCrate && hitState.func_177229_b((IProperty)BotaniaStateProps.CRATE_VARIANT) == CrateVariant.OPEN) {
            ItemNBTHelper.setCompound((ItemStack)heldStack, (String)CRATE_POS_KEY, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)pos));
            ItemNBTHelper.setInt((ItemStack)heldStack, (String)CRATE_DIMENSION_KEY, (int)world.field_73011_w.getDimension());
            EtcHelpers.sendMessage(player, "incorporeal.fracturedSpace.savedPos", TextFormatting.DARK_PURPLE);
            return EnumActionResult.SUCCESS;
        }
        if (facing != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        NBTTagCompound cratePosCmp = ItemNBTHelper.getCompound((ItemStack)heldStack, (String)CRATE_POS_KEY, (boolean)true);
        int crateDimension = ItemNBTHelper.getInt((ItemStack)heldStack, (String)CRATE_DIMENSION_KEY, (int)Integer.MAX_VALUE);
        if (cratePosCmp == null || crateDimension == Integer.MAX_VALUE) {
            EtcHelpers.sendMessage(player, "incorporeal.fracturedSpace.noPos", TextFormatting.RED);
            return EnumActionResult.FAIL;
        }
        if (crateDimension != world.field_73011_w.getDimension()) {
            EtcHelpers.sendMessage(player, "incorporeal.fracturedSpace.wrongDimension", TextFormatting.RED);
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            TileEntity rememberedTile;
            BlockPos cratePos = NBTUtil.func_186861_c((NBTTagCompound)cratePosCmp);
            IBlockState rememberedState = world.func_180495_p(cratePos);
            if (!EtcHelpers.isOpenCrate(rememberedState, rememberedTile = world.func_175625_s(cratePos))) {
                EtcHelpers.sendMessage(player, "incorporeal.fracturedSpace.noCrateThere", TextFormatting.RED);
                return EnumActionResult.FAIL;
            }
            EntityFracturedSpaceCollector fsc = new EntityFracturedSpaceCollector(world, cratePos, player);
            fsc.func_70107_b((float)pos.func_177958_n() + hitX, pos.func_177956_o() + 1, (float)pos.func_177952_p() + hitZ);
            world.func_72838_d((Entity)fsc);
        }
        return EnumActionResult.SUCCESS;
    }

    public BlockPos getBinding(ItemStack stack) {
        NBTTagCompound cratePosCmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)CRATE_POS_KEY, (boolean)true);
        if (cratePosCmp == null) {
            return null;
        }
        int dimension = ItemNBTHelper.getInt((ItemStack)stack, (String)CRATE_DIMENSION_KEY, (int)Integer.MAX_VALUE);
        if (dimension == Integer.MAX_VALUE || Incorporeal.PROXY.getClientDimension() != dimension) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)cratePosCmp);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag mistake) {
        NBTTagCompound cratePosCmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)CRATE_POS_KEY, (boolean)true);
        if (cratePosCmp == null) {
            tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"incorporeal.fracturedSpace.tooltipNotBound"));
        } else {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"incorporeal.fracturedSpace.tooltipBound"));
            int crateDimension = ItemNBTHelper.getInt((ItemStack)stack, (String)CRATE_DIMENSION_KEY, (int)Integer.MAX_VALUE);
            if (world != null && (crateDimension == Integer.MAX_VALUE || world.field_73011_w.getDimension() != crateDimension)) {
                tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"incorporeal.fracturedSpace.tooltipWrongDimension"));
            }
            if (mistake.func_194127_a()) {
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)cratePosCmp);
                tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74837_a((String)"incorporeal.fracturedSpace.debug.tooltipPos", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
                tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74837_a((String)"incorporeal.fracturedSpace.debug.tooltipDim", (Object[])new Object[]{crateDimension}));
            }
        }
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.fracturedSpace;
    }
}

