/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.item.cygnus;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemCygnusTicket
extends Item {
    private static final String TAG_CYGNUS_DATA = "CygnusItem";

    public ItemCygnusTicket() {
        this.func_185043_a(new ResourceLocation("incorporeal", "written_ticket"), (stack, worldIn, entityIn) -> this.hasCygnusItem(stack) ? 1.0f : 0.0f);
    }

    public void setCygnusItem(ItemStack stack, Object o) {
        this.clearCygnusItem(stack);
        if (o != null) {
            NBTTagCompound cygnusData = new NBTTagCompound();
            CygnusDatatypeHelpers.writeToNBT(cygnusData, o);
            ItemNBTHelper.getNBT((ItemStack)stack).func_74782_a(TAG_CYGNUS_DATA, (NBTBase)cygnusData);
        }
    }

    public boolean hasCygnusItem(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(TAG_CYGNUS_DATA);
    }

    public Object getCygnusItem(ItemStack stack) {
        return CygnusDatatypeHelpers.readFromNBT(stack.func_77978_p().func_74775_l(TAG_CYGNUS_DATA));
    }

    public void clearCygnusItem(ItemStack stack) {
        if (this.hasCygnusItem(stack)) {
            stack.func_77978_p().func_82580_o(TAG_CYGNUS_DATA);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag mistake) {
        if (world != null) {
            if (this.hasCygnusItem(stack)) {
                Object o = this.getCygnusItem(stack);
                ICygnusDatatype<?> type = CygnusDatatypeHelpers.forClass(o.getClass());
                String typeName = I18n.func_74838_a((String)type.getTranslationKey());
                tooltip.add(TextFormatting.GREEN + I18n.func_74837_a((String)EtcHelpers.vowelizeTranslationKey("incorporeal.cygnus.retainer.some", typeName), (Object[])new Object[]{typeName}));
                tooltip.addAll(type.describeUnchecked(o));
            } else {
                tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"incorporeal.cygnus.retainer.none"));
            }
        }
    }
}

