/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.lexicon;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quaternary.incorporeal.IncorporeticConfig;
import quaternary.incorporeal.block.IncorporeticBlocks;
import quaternary.incorporeal.item.IncorporeticItems;
import quaternary.incorporeal.recipe.IncorporeticPetalRecipes;
import quaternary.incorporeal.recipe.IncorporeticRuneRecipes;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.lexicon.CompatLexiconEntry;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageCraftingRecipe;
import vazkii.botania.common.lexicon.page.PagePetalRecipe;
import vazkii.botania.common.lexicon.page.PageRuneRecipe;
import vazkii.botania.common.lexicon.page.PageText;

public final class IncorporeticLexicon {
    public static LexiconCategory categoryCorporetic = null;
    public static LexiconEntry frameTinkerer;
    public static LexiconEntry naturalDevices;
    public static LexiconEntry unstableCubes;
    public static LexiconEntry sweetAlexum;
    public static LexiconEntry fracturedSpace;
    public static LexiconEntry ticketConjurer;
    public static LexiconEntry corporeaInhibitor;
    public static LexiconEntry corporeaSolidifier;
    public static LexiconEntry corporeaTinkerer;
    public static LexiconEntry corporeaRetainerDecrementer;
    public static LexiconEntry soulCores;
    public static LexiconEntry sanvocalia;
    public static LexiconEntry redStringLiar;
    private static KnowledgeType newEntryType;

    private IncorporeticLexicon() {
    }

    public static void init() {
        if (IncorporeticConfig.General.CORPOREA_KNOWLEDGE_TYPE) {
            categoryCorporetic = new LexiconCategory("incorporeal.category.corporea").setPriority(3).setIcon(new ResourceLocation("incorporeal", "textures/lexicon/categories/corporea.png"));
            BotaniaAPI.addCategory((LexiconCategory)categoryCorporetic);
            for (LexiconEntry e : new LexiconEntry[]{LexiconData.corporea, LexiconData.corporeaCrystalCube, LexiconData.corporeaFunnel, LexiconData.corporeaIndex, LexiconData.corporeaInterceptor, LexiconData.corporeaRetainer}) {
                BotaniaAPI.addEntry((LexiconEntry)e, (LexiconCategory)categoryCorporetic);
                BotaniaAPI.categoryEnder.entries.remove(e);
            }
            LexiconData.corporea.setPriority();
        } else {
            categoryCorporetic = BotaniaAPI.categoryEnder;
        }
        newEntryType = BotaniaAPI.basicKnowledge;
        frameTinkerer = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.FRAME_TINKERER, BotaniaAPI.categoryDevices, 1);
        naturalDevices = new CompatLexiconEntry("incorporeal.naturalDevices", BotaniaAPI.categoryDevices, "Incorporeal").setLexiconPages(new LexiconPage[]{new PageText("0"), new PageText("1"), new PageText("2")});
        naturalDevices.setIcon(new ItemStack((Item)IncorporeticItems.NATURAL_COMPARATOR));
        naturalDevices.addExtraDisplayedRecipe(new ItemStack((Item)IncorporeticItems.NATURAL_REPEATER));
        naturalDevices.addExtraDisplayedRecipe(new ItemStack(ModItems.manaResource, 1, 6));
        naturalDevices.setKnowledgeType(newEntryType);
        unstableCubes = new CompatLexiconEntry("incorporeal.unstableCubes", BotaniaAPI.categoryMisc, "Incorporeal").setLexiconPages(new LexiconPage[]{new PageText("0"), new PageCraftingRecipe(".flavor", Arrays.stream(EnumDyeColor.values()).map(color -> "decorative/unstable_cube/unstable_cube_" + color.func_176610_l()).map(str -> new ResourceLocation("incorporeal", str)).collect(Collectors.toList()))});
        sweetAlexum = IncorporeticLexicon.buildFlowerEntry("sweet_alexum", IncorporeticPetalRecipes.sweetAlexum, BotaniaAPI.categoryFunctionalFlowers, 2);
        newEntryType = BotaniaAPI.elvenKnowledge;
        fracturedSpace = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticItems.FRACTURED_SPACE_ROD, BotaniaAPI.categoryTools, 2);
        ticketConjurer = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticItems.TICKET_CONJURER, categoryCorporetic, 2);
        corporeaInhibitor = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.CORPOREA_INHIBITOR, categoryCorporetic, 1);
        corporeaSolidifier = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.CORPOREA_SOLIDIFIER, categoryCorporetic, 2);
        corporeaTinkerer = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.CORPOREA_SPARK_TINKERER, categoryCorporetic, 2);
        corporeaRetainerDecrementer = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.CORPOREA_RETAINER_DECREMENTER, categoryCorporetic, 2);
        soulCores = new CompatLexiconEntry("incorporeal.soulCores", categoryCorporetic, "Incorporeal");
        soulCores.setLexiconPages(new LexiconPage[]{new PageText("0"), new PageText("1"), new PageRuneRecipe(".flavor2", IncorporeticRuneRecipes.soulCoreFrame), new PageText("3"), new PageRuneRecipe(".flavor3", IncorporeticRuneRecipes.enderSoulCore), new PageText("4"), new PageRuneRecipe(".flavor4", IncorporeticRuneRecipes.corporeaSoulCore), new PageText("5"), new PageRuneRecipe(".flavor5", IncorporeticRuneRecipes.potionSoulCore)});
        soulCores.setKnowledgeType(newEntryType);
        soulCores.addExtraDisplayedRecipe(new ItemStack((Item)IncorporeticItems.CORPOREA_SOUL_CORE));
        soulCores.addExtraDisplayedRecipe(new ItemStack((Item)IncorporeticItems.ENDER_SOUL_CORE));
        soulCores.setIcon(new ItemStack((Item)IncorporeticItems.CORPOREA_SOUL_CORE));
        sanvocalia = IncorporeticLexicon.buildFlowerEntry("sanvocalia", IncorporeticPetalRecipes.sanvocalia, BotaniaAPI.categoryFunctionalFlowers, 1);
        redStringLiar = IncorporeticLexicon.buildCraftingEntry((IForgeRegistryEntry)IncorporeticBlocks.RED_STRING_LIAR, categoryCorporetic, 2);
    }

    private static LexiconEntry buildCraftingEntry(IForgeRegistryEntry subject, LexiconCategory category, int pageCount) {
        ItemStack icon;
        String name = "incorporeal." + ((ResourceLocation)Preconditions.checkNotNull((Object)subject.getRegistryName())).func_110623_a();
        if (subject instanceof Block) {
            icon = new ItemStack((Block)subject);
        } else if (subject instanceof Item) {
            icon = new ItemStack((Item)subject);
        } else {
            throw new IllegalArgumentException("Can't determine the lexicon page item for " + subject + " if you see this quat is a big stupid");
        }
        PageCraftingRecipe terminalPage = new PageCraftingRecipe(".flavor", subject.getRegistryName());
        return IncorporeticLexicon.buildEntryInternal(name, icon, category, pageCount, (LexiconPage)terminalPage);
    }

    private static LexiconEntry buildFlowerEntry(String name, RecipePetals recipe, LexiconCategory category, int pageCount) {
        ItemStack icon = ItemBlockSpecialFlower.ofType((String)name);
        PagePetalRecipe terminalPage = new PagePetalRecipe(".flavor", recipe);
        return IncorporeticLexicon.buildEntryInternal(name, icon, category, pageCount, (LexiconPage)terminalPage);
    }

    private static LexiconEntry buildEntryInternal(String name, ItemStack icon, LexiconCategory category, int pageCount, LexiconPage terminalPage) {
        CompatLexiconEntry entry = new CompatLexiconEntry(name, category, "Incorporeal");
        for (int i = 0; i < pageCount; ++i) {
            entry.setLexiconPages(new LexiconPage[]{new PageText(String.valueOf(i))});
        }
        entry.setLexiconPages(new LexiconPage[]{terminalPage});
        entry.setIcon(icon);
        entry.setKnowledgeType(newEntryType);
        return entry;
    }

    static {
        newEntryType = BotaniaAPI.basicKnowledge;
    }
}

