/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.recipe.skytouch;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import quaternary.incorporeal.api.recipe.IRecipeSkytouching;
import quaternary.incorporeal.etc.helper.EtcHelpers;

public class RecipeSkytouching
implements IRecipeSkytouching {
    public static final int DEFAULT_MINY = 260;
    public static final int DEFAULT_MAXY = 300;
    public static final int DEFAULT_MULTIPLIER = 4;
    private final ItemStack out;
    private final ItemStack in;
    private final int minY;
    private final int maxY;
    private final int multiplier;

    public RecipeSkytouching(ItemStack out, ItemStack in, int minY, int maxY, int multiplier) {
        this.out = out;
        this.in = in;
        this.minY = minY;
        this.maxY = maxY;
        this.multiplier = multiplier;
    }

    public RecipeSkytouching(ItemStack out, ItemStack in) {
        this(out, in, 260, 300, 4);
    }

    @Override
    public boolean matches(EntityItem ent) {
        return ent.field_70163_u >= (double)this.minY && ItemStack.func_185132_d((ItemStack)ent.func_92059_d(), (ItemStack)this.in);
    }

    @Override
    public List<ItemStack> getOutputs(EntityItem ent) {
        int itemsToDispense;
        double bonus = EtcHelpers.rangeRemap(ent.field_70163_u, (double)this.minY, (double)this.maxY, 1.0, (double)this.multiplier);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (itemsToDispense <= this.out.func_77976_d()) {
            ItemStack outC = this.out.func_77946_l();
            outC.func_190920_e(itemsToDispense);
            result.add(outC);
        } else {
            int dispensedItems;
            for (itemsToDispense = ent.func_92059_d().func_190916_E() * (int)Math.round((double)this.out.func_190916_E() * bonus); itemsToDispense > 0; itemsToDispense -= dispensedItems) {
                dispensedItems = Math.min(itemsToDispense, this.out.func_77976_d());
                ItemStack outC = this.out.func_77946_l();
                outC.func_190920_e(dispensedItems);
                result.add(outC);
            }
        }
        ItemStack container = ent.func_92059_d().func_77973_b().getContainerItem(ent.func_92059_d());
        if (!container.func_190926_b()) {
            result.add(container.func_77946_l());
        }
        return result;
    }

    @Override
    public List<ItemStack> getGenericInputs() {
        return ImmutableList.of((Object)this.in);
    }

    @Override
    public ItemStack getGenericOutput() {
        return this.out;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMultiplier() {
        return this.multiplier;
    }
}

