/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.spookyasm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import quaternary.incorporeal.spookyasm.SpookyClassWriter;
import quaternary.incorporeal.spookyasm.tweaks.AbstractTweak;
import quaternary.incorporeal.spookyasm.tweaks.CorporeaInhibitorTweak;
import quaternary.incorporeal.spookyasm.tweaks.InventoryWrapTweak;

public class IncorporealTransformer
implements IClassTransformer,
Opcodes {
    public static final Logger LOG = LogManager.getLogger((String)"Incorporeal ASM");
    private static final List<AbstractTweak> allTweaks = new ArrayList<AbstractTweak>();
    private static final List<String> patches = new ArrayList<String>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!patches.contains(transformedName)) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (AbstractTweak tweak : allTweaks) {
            tweak.accept(node, transformedName);
        }
        SpookyClassWriter writer = new SpookyClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        allTweaks.add(new InventoryWrapTweak());
        allTweaks.add(new CorporeaInhibitorTweak());
        for (AbstractTweak tweak : allTweaks) {
            patches.addAll(tweak.getAffectedClassNames());
        }
    }
}

