/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.spookyasm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import quaternary.incorporeal.spookyasm.tweaks.AbstractTweak;

public class InventoryWrapTweak
extends AbstractTweak {
    @Override
    protected String describe(String transformedName) {
        return "Adding inventory wrap hook...";
    }

    @Override
    protected List<String> computeAffectedClassNames() {
        return ImmutableList.of((Object)"vazkii.botania.common.core.handler.InternalMethodHandler");
    }

    @Override
    protected void patch(ClassNode node, String transformedName) {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals("wrapInventory")) continue;
            InsnList instructions = methodNode.instructions;
            int searchIndex = instructions.size() - 1;
            while (instructions.get(searchIndex).getOpcode() != 199) {
                --searchIndex;
            }
            AbstractInsnNode insertionPoint = instructions.get(--searchIndex);
            instructions.insertBefore(insertionPoint, (AbstractInsnNode)new VarInsnNode(25, 4));
            instructions.insertBefore(insertionPoint, (AbstractInsnNode)new VarInsnNode(25, 5));
            instructions.insertBefore(insertionPoint, (AbstractInsnNode)new VarInsnNode(25, 6));
            instructions.insertBefore(insertionPoint, (AbstractInsnNode)new MethodInsnNode(184, "quaternary/incorporeal/spookyasm/Hooks", "invWrapHook", "(Lvazkii/botania/api/corporea/InvWithLocation;Lvazkii/botania/api/corporea/ICorporeaSpark;Lvazkii/botania/api/corporea/IWrappedInventory;)Lvazkii/botania/api/corporea/IWrappedInventory;", false));
            instructions.insertBefore(insertionPoint, (AbstractInsnNode)new VarInsnNode(58, 6));
            return;
        }
    }
}

