/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.tile.cygnus;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import quaternary.incorporeal.api.cygnus.ICygnusFunnelable;
import quaternary.incorporeal.api.cygnus.ILooseCygnusFunnelable;
import quaternary.incorporeal.block.cygnus.BlockCygnusFunnel;
import quaternary.incorporeal.cygnus.CygnusRegistries;
import quaternary.incorporeal.cygnus.CygnusStack;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.etc.helper.CygnusHelpers;

public class TileCygnusFunnel
extends TileEntity
implements ITickable {
    private boolean isPowered;
    private boolean backLit;
    private boolean frontLit;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.updateArrowStatus(this.field_174879_c, (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockCygnusFunnel.FACING));
        }
    }

    public void updateArrowStatus(BlockPos pos, EnumFacing facing) {
        BlockPos fromPos = pos.func_177972_a(facing.func_176734_d());
        BlockPos toPos = pos.func_177972_a(facing);
        boolean oldBackLit = this.backLit;
        boolean oldFrontLit = this.frontLit;
        ICygnusFunnelable backFunnelable = TileCygnusFunnel.getCygnusFunnelable(this.field_145850_b, fromPos, facing);
        this.backLit = backFunnelable != null && backFunnelable.canGiveCygnusItem();
        ICygnusFunnelable frontFunnelable = TileCygnusFunnel.getCygnusFunnelable(this.field_145850_b, toPos, facing.func_176734_d());
        boolean bl = this.frontLit = frontFunnelable != null && frontFunnelable.canAcceptCygnusItem();
        if (oldBackLit != this.backLit || oldFrontLit != this.frontLit) {
            IBlockState memes = this.field_145850_b.func_180495_p(pos);
            this.field_145850_b.func_184138_a(pos, memes, memes, 3);
        }
    }

    public void onNeighborChange() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b(BlockCygnusFunnel.FACING);
        boolean shouldPower = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.isPowered != shouldPower) {
            this.isPowered = shouldPower;
            this.func_70296_d();
            if (shouldPower) {
                boolean sinkCanAccept;
                BlockPos fromPos = this.field_174879_c.func_177972_a(facing.func_176734_d());
                BlockPos toPos = this.field_174879_c.func_177972_a(facing);
                ICygnusFunnelable source = TileCygnusFunnel.getCygnusFunnelable(this.field_145850_b, fromPos, facing);
                ICygnusFunnelable sink = TileCygnusFunnel.getCygnusFunnelable(this.field_145850_b, toPos, facing.func_176734_d());
                this.backLit = source != null;
                this.frontLit = source != null;
                boolean sourceCanGive = source != null && source.canGiveCygnusItem();
                boolean bl = sinkCanAccept = sink != null && sink.canAcceptCygnusItem();
                if (!sourceCanGive && !sinkCanAccept) {
                    return;
                }
                if (sourceCanGive && sinkCanAccept) {
                    sink.acceptItemFromCygnus(source.giveItemToCygnus());
                    return;
                }
                EntityCygnusMasterSpark master = CygnusHelpers.getMasterSparkForSparkAt(this.field_145850_b, this.field_174879_c);
                if (master == null) {
                    return;
                }
                CygnusStack stack = master.getCygnusStack();
                if (sourceCanGive) {
                    Optional.ofNullable(source.giveItemToCygnus()).ifPresent(stack::push);
                } else {
                    stack.pop().ifPresent(sink::acceptItemFromCygnus);
                }
            }
        }
    }

    public boolean isBackLit() {
        return this.backLit;
    }

    public boolean isFrontLit() {
        return this.frontLit;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 6969, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        IBlockState yes = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, yes, yes, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("Powered", this.isPowered);
        nbt.func_74757_a("DisplayBack", this.backLit);
        nbt.func_74757_a("DisplayFront", this.frontLit);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isPowered = nbt.func_74767_n("powered");
        this.backLit = nbt.func_74767_n("DisplayBack");
        this.frontLit = nbt.func_74767_n("DisplayFront");
    }

    @Nullable
    private static ICygnusFunnelable getCygnusFunnelable(World world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof ICygnusFunnelable) {
            return (ICygnusFunnelable)b;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ICygnusFunnelable capMaybe = (ICygnusFunnelable)tile.getCapability(IncorporeticCygnusCapabilities.FUNNEL_CAP, null);
            if (capMaybe != null) {
                return capMaybe;
            }
            capMaybe = (ICygnusFunnelable)tile.getCapability(IncorporeticCygnusCapabilities.FUNNEL_CAP, face);
            if (capMaybe != null) {
                return capMaybe;
            }
        }
        List entities = world.func_72872_a(Entity.class, new AxisAlignedBB(pos));
        for (Entity e : entities) {
            ICygnusFunnelable capMaybe = (ICygnusFunnelable)e.getCapability(IncorporeticCygnusCapabilities.FUNNEL_CAP, null);
            if (capMaybe != null) {
                return capMaybe;
            }
            capMaybe = (ICygnusFunnelable)e.getCapability(IncorporeticCygnusCapabilities.FUNNEL_CAP, face);
            if (capMaybe == null) continue;
            return capMaybe;
        }
        for (ILooseCygnusFunnelable loose : CygnusRegistries.LOOSE_FUNNELABLES) {
            ICygnusFunnelable f = loose.getFor(world, pos, state, face);
            if (f == null) continue;
            return f;
        }
        return null;
    }
}

