/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.tile.cygnus;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import quaternary.incorporeal.api.cygnus.ICygnusFunnelable;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.tile.cygnus.TileCygnusBase;

public class TileCygnusRetainer
extends TileCygnusBase
implements ICygnusFunnelable {
    @Nullable
    private Object retained;
    private int comparator;

    @Override
    public boolean canGiveCygnusItem() {
        return true;
    }

    @Override
    public boolean canAcceptCygnusItem() {
        return true;
    }

    @Override
    @Nullable
    public Object giveItemToCygnus() {
        Object ret = this.retained;
        this.retained = null;
        this.comparator = 0;
        this.updateStuff();
        return ret;
    }

    @Override
    public void acceptItemFromCygnus(Object item) {
        this.retained = item;
        if (item != null) {
            this.comparator = CygnusDatatypeHelpers.forClass(item.getClass()).toComparatorUnchecked(item);
        }
        this.updateStuff();
    }

    private void updateStuff() {
        this.func_70296_d();
        IBlockState ok = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, ok, ok, 2);
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
    }

    public void wand() {
        this.retained = null;
        this.updateStuff();
    }

    public boolean hasRetainedObject() {
        return this.retained != null;
    }

    @Nullable
    public Object getRetainedObject() {
        return this.retained;
    }

    public int getComparator() {
        return this.comparator;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.retained != null) {
            NBTTagCompound retainedNBT = new NBTTagCompound();
            CygnusDatatypeHelpers.writeToNBT(retainedNBT, this.retained);
            nbt.func_74782_a("Retained", (NBTBase)retainedNBT);
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("Retained")) {
            this.retained = CygnusDatatypeHelpers.readFromNBT(nbt.func_74775_l("Retained"));
            this.comparator = CygnusDatatypeHelpers.forClass(this.retained.getClass()).toComparatorUnchecked(this.retained);
        } else {
            this.retained = null;
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 6969, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateStuff();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == IncorporeticCygnusCapabilities.FUNNEL_CAP;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == IncorporeticCygnusCapabilities.FUNNEL_CAP) {
            return (T)this;
        }
        return null;
    }
}

