/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.tile.soulcore;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.core.handler.HUDHandler;

public abstract class AbstractTileSoulCore
extends TileEntity
implements ITickable,
IManaReceiver {
    protected GameProfile ownerProfile;
    protected int mana;
    public static final DamageSource SOUL = new DamageSource("incorporeal.soul").func_82726_p();

    protected abstract int getMaxMana();

    public boolean hasOwnerProfile() {
        return this.ownerProfile != null;
    }

    public GameProfile getOwnerProfile() {
        return this.ownerProfile;
    }

    public boolean setOwnerProfile(GameProfile newProfile) {
        if (newProfile != null && newProfile.equals((Object)this.ownerProfile)) {
            return false;
        }
        this.ownerProfile = newProfile;
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
        return true;
    }

    public Optional<EntityPlayer> findPlayer() {
        if (!this.hasOwnerProfile()) {
            return Optional.empty();
        }
        GameProfile prof = this.getOwnerProfile();
        for (EntityPlayer playerEnt : this.field_145850_b.field_73010_i) {
            if (!playerEnt.func_146103_bH().equals((Object)prof)) continue;
            return Optional.of(playerEnt);
        }
        return Optional.empty();
    }

    public boolean click(EntityPlayer player) {
        boolean isDifferent = this.setOwnerProfile(player.func_146103_bH());
        if (isDifferent) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_70097_a(SOUL, 5.0f);
                this.receiveInitialMana();
            }
            return true;
        }
        return false;
    }

    public void receiveInitialMana() {
        int n = this.getMaxMana() / 2;
        if (this.mana < n) {
            this.mana = n;
        }
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public void drainMana(int manaPoof) {
        if (manaPoof < 0) {
            manaPoof = 0;
        }
        this.mana -= manaPoof;
        if (this.mana <= 0) {
            this.mana = 0;
        }
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public void func_73660_a() {
        if (this.getMaxMana() == 0) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mana <= 0 && this.hasOwnerProfile()) {
            this.findPlayer().ifPresent(owningPlayer -> owningPlayer.func_70097_a(SOUL, 5.0f));
            this.setOwnerProfile(null);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, 1.2f);
        }
    }

    public int getComparatorValue() {
        if (this.getMaxMana() == 0) {
            return 0;
        }
        return Math.round(EtcHelpers.rangeRemap(this.mana, 0.0f, this.getMaxMana(), 0.0f, 15.0f));
    }

    public boolean isFull() {
        if (this.getMaxMana() == 0) {
            return true;
        }
        return this.mana >= this.getMaxMana();
    }

    public void recieveMana(int moreMana) {
        this.mana = Math.min(this.mana + moreMana, this.getMaxMana());
        this.func_70296_d();
    }

    public boolean canRecieveManaFromBursts() {
        return this.getMaxMana() != 0;
    }

    public int getCurrentMana() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        Item i = Item.func_150898_a((Block)this.func_145838_q());
        String name = I18n.func_135052_a((String)(i.func_77658_a() + ".name"), (Object[])new Object[0]);
        HUDHandler.drawSimpleManaHUD((int)0xEE4444, (int)this.mana, (int)this.getMaxMana(), (String)name, (ScaledResolution)res);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 6969, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        IBlockState memes = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, memes, memes, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.ownerProfile != null) {
            nbt.func_74782_a("Owner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.ownerProfile));
        }
        nbt.func_74768_a("Mana", this.mana);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerProfile = nbt.func_74764_b("Owner") ? NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("Owner")) : null;
        this.mana = nbt.func_74762_e("Mana");
    }
}

