/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.tile.soulcore;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import quaternary.incorporeal.tile.soulcore.AbstractTileSoulCore;

public class TileEnderSoulCore
extends AbstractTileSoulCore {
    private IItemHandler handler = EmptyHandler.INSTANCE;
    private boolean wasOnline = false;

    @Override
    protected int getMaxMana() {
        return 5000;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Optional<EntityPlayer> opPlayer = this.findPlayer();
        boolean isOnline = opPlayer.isPresent();
        if (!this.wasOnline && isOnline) {
            this.handler = new ManaDrainingInvWrapper((IInventory)opPlayer.get().func_71005_bN());
        } else if (this.wasOnline && !isOnline) {
            this.handler = EmptyHandler.INSTANCE;
        }
        this.wasOnline = isOnline;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public class ManaDrainingInvWrapper
    extends InvWrapper {
        public ManaDrainingInvWrapper(IInventory inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack sup = super.extractItem(slot, amount, simulate);
            if (!simulate) {
                TileEnderSoulCore.this.drainMana(5 * sup.func_190916_E());
            }
            return sup;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack sup = super.insertItem(slot, stack, simulate);
            if (!simulate) {
                TileEnderSoulCore.this.drainMana(5 * (stack.func_190916_E() - sup.func_190916_E()));
            }
            return sup;
        }
    }
}

