/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.movillages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import weatherpony.movillages.IBlockChanger;
import weatherpony.movillages.StandardChangerSetup;

public class MoVillagesBiomeManager {
    public static final MoVillagesBiomeManager INSTANCE = new MoVillagesBiomeManager();
    private List<Callable> redirectRegistrationRequests = new ArrayList<Callable>();
    private List<Callable> changerRegistrationRequests = new ArrayList<Callable>();
    private HashMap<ResourceLocation, ResourceLocation> biomeRedirects = new HashMap();
    private HashMap<ResourceLocation, IBlockChanger> changers = new HashMap();
    private boolean postInitializedAlready = false;

    public static void init() {
        StandardChangerSetup.register();
    }

    public void registerRedirectRegistrationRequest(Callable request) {
        if (request == null) {
            throw new NullPointerException();
        }
        this.redirectRegistrationRequests.add(request);
    }

    public void registerChangerRegistrationRequest(Callable request) {
        if (request == null) {
            throw new NullPointerException();
        }
        this.changerRegistrationRequests.add(request);
    }

    public void afterModInit() {
        if (this.postInitializedAlready) {
            return;
        }
        this.postInitializedAlready = true;
        Iterator biomeIter = Biome.field_185377_q.iterator();
        while (biomeIter.hasNext()) {
            ResourceLocation eachBiomeName = ((Biome)biomeIter.next()).getRegistryName();
            this.biomeRedirects.put(eachBiomeName, eachBiomeName);
        }
        this.processRegistrationRequests(this.redirectRegistrationRequests);
        this.factorRedirects();
        this.processRegistrationRequests(this.changerRegistrationRequests);
    }

    private void processRegistrationRequests(List<Callable> requests) {
        for (Callable each : requests) {
            try {
                each.call();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void factorRedirects() {
        HashMap<ResourceLocation, ResourceLocation> temp = new HashMap<ResourceLocation, ResourceLocation>(this.biomeRedirects);
        this.biomeRedirects.clear();
        for (Map.Entry eachRedirect : temp.entrySet()) {
            ResourceLocation eachFrom;
            ResourceLocation from = (ResourceLocation)eachRedirect.getKey();
            if (this.biomeRedirects.containsKey(from)) continue;
            ArrayList<ResourceLocation> passing = new ArrayList<ResourceLocation>();
            ResourceLocation redirectedTo = this.determineRedirect(from, temp, passing);
            Iterator iterator = passing.iterator();
            while (iterator.hasNext() && !this.biomeRedirects.containsKey(eachFrom = (ResourceLocation)iterator.next())) {
                this.biomeRedirects.put(eachFrom, redirectedTo);
            }
        }
    }

    private ResourceLocation determineRedirect(ResourceLocation from, Map<ResourceLocation, ResourceLocation> redirects, List<ResourceLocation> passingThrough) {
        passingThrough.add(from);
        ResourceLocation redirectedTo = redirects.get(from);
        if (redirectedTo == null || redirectedTo.equals((Object)from)) {
            return from;
        }
        return this.determineRedirect(redirectedTo, redirects, passingThrough);
    }

    public void addRedirect(ResourceLocation biomeFrom, ResourceLocation biomeTo) {
        this.biomeRedirects.put(biomeFrom, biomeTo);
    }

    public void addChanger(ResourceLocation forBiome, IBlockChanger changer) {
        ResourceLocation redirected = this.getRedirect(forBiome);
        if (redirected != null && !forBiome.equals((Object)redirected)) {
            throw new IllegalStateException("" + forBiome + ',' + redirected);
        }
        this.changers.put(forBiome, changer);
    }

    public ResourceLocation getRedirect(Biome biome) {
        return this.getRedirect(biome.getRegistryName());
    }

    public ResourceLocation getRedirect(ResourceLocation from) {
        return this.biomeRedirects.get(from);
    }

    public IBlockChanger getChanger(ResourceLocation from) {
        return this.changers.get(this.getRedirect(from));
    }

    public IBlockChanger getChanger(Biome biome) {
        return this.changers.get(this.getRedirect(biome));
    }
}

