/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.movillages.upcoming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import weatherpony.movillages.IBlockChanger;

public class BuildableBlockChanger
implements IBlockChanger {
    private List<ChangeAction> changers = new ArrayList<ChangeAction>();
    private Map<IBlockState, IBlockState> cached = new HashMap<IBlockState, IBlockState>();

    protected void addChange(ICondition condition, IChange change) {
        this.changers.add(new ChangeAction(condition, change));
    }

    @Override
    public IBlockState getBlockChange(IBlockState normalBlock) {
        if (this.cached.containsKey(normalBlock)) {
            return this.cached.get(normalBlock);
        }
        IBlockState changeTo = null;
        for (ChangeAction each : this.changers) {
            changeTo = each.change(normalBlock);
            if (changeTo == null) continue;
            this.cached.put(normalBlock, changeTo);
            return changeTo;
        }
        this.cached.put(normalBlock, null);
        return null;
    }

    private static class ChangeAction {
        private final ICondition condition;
        private final IChange change;

        ChangeAction(ICondition condition, IChange change) {
            this.condition = condition;
            this.change = change;
        }

        IBlockState change(IBlockState starting) {
            if (this.condition.matches(starting)) {
                return this.change.change(starting);
            }
            return null;
        }
    }

    static interface IChange {
        public IBlockState change(IBlockState var1);
    }

    static interface ICondition {
        public boolean matches(IBlockState var1);
    }
}

