/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.movillages.upcoming;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import weatherpony.movillages.IBlockChanger;
import weatherpony.movillages.MoVillagesBiomeManager;
import weatherpony.movillages.upcoming.BuildableBlockChanger;

public class ChangerBuilder {
    public static void parseAndRegister(BufferedReader in) {
        HashSet<String> modNames = new HashSet<String>();
        for (ModContainer modc : Loader.instance().getActiveModList()) {
            modNames.add(modc.getName().trim().toLowerCase());
        }
        modNames.add("minecraft");
        BuildableBlockChanger.ICondition alwaysCondition = new BuildableBlockChanger.ICondition(){

            @Override
            public boolean matches(IBlockState starting) {
                return true;
            }
        };
        try {
            HashMap<ResourceLocation, BuildableBlockChanger> parsed = new HashMap<ResourceLocation, BuildableBlockChanger>();
            ResourceLocation biome = null;
            BuildableBlockChanger changer = null;
            boolean meetsRequirements = true;
            block12: while (in.ready()) {
                String line = in.readLine().split(";")[0];
                if (line.isEmpty()) continue;
                if (line.startsWith("\t")) {
                    if (!meetsRequirements) continue;
                    if (line.startsWith("\t\t")) {
                        if (biome == null) continue;
                        if (line.startsWith("\t\tuse ")) {
                            final ResourceLocation useBiome = new ResourceLocation(line.substring(6));
                            changer.addChange(alwaysCondition, new BuildableBlockChanger.IChange(){

                                @Override
                                public IBlockState change(IBlockState starting) {
                                    return MoVillagesBiomeManager.INSTANCE.getChanger(useBiome).getBlockChange(starting);
                                }
                            });
                            continue;
                        }
                        if ((line = line.trim()).isEmpty()) continue;
                        String[] blockInfo = line.split("->");
                        if (blockInfo.length == 2) {
                            BuildableBlockChanger.IChange change;
                            String[] blockInfoOfSegments = new String[2];
                            int[] metaInfoOfSegments = new int[2];
                            for (int blockN = 0; blockN < 2; ++blockN) {
                                metaInfoOfSegments[blockN] = -1;
                                String[] blockInfoSegment = blockInfo[blockN].split(" meta ");
                                if (blockInfoSegment.length > 2) {
                                    throw new Exception("Invalid block information segment: " + blockInfo[blockN]);
                                }
                                String blockName = blockInfoSegment[0].trim();
                                if (blockName.isEmpty()) {
                                    if (blockN == 0) {
                                        throw new Exception("Invalid block information segment (must delare starting block name)");
                                    }
                                } else {
                                    blockInfoOfSegments[blockN] = new ResourceLocation(blockName).toString();
                                }
                                if (blockInfoSegment.length != 2) continue;
                                String metaString = blockInfoSegment[1].trim();
                                if (metaString.equalsIgnoreCase("keep")) {
                                    if (blockN == 1) {
                                        metaInfoOfSegments[blockN] = -2;
                                        continue;
                                    }
                                    throw new Exception("Invalid block information segment (cannot use 'meta keep' on starting block info)");
                                }
                                if (metaString.equalsIgnoreCase("default")) continue;
                                int meta = Integer.parseInt(metaString);
                                if (meta > 15 || meta < 0) {
                                    throw new Exception("Invalid block information segment (out of range meta value)");
                                }
                                metaInfoOfSegments[blockN] = meta;
                                continue;
                            }
                            final String startBlock = blockInfoOfSegments[0];
                            final int startingMeta = metaInfoOfSegments[0];
                            BuildableBlockChanger.ICondition condition = startingMeta == -1 ? new BuildableBlockChanger.ICondition(){

                                @Override
                                public boolean matches(IBlockState starting) {
                                    return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)starting.func_177230_c())).toString().equals(startBlock);
                                }
                            } : new BuildableBlockChanger.ICondition(){

                                @Override
                                public boolean matches(IBlockState starting) {
                                    Block block = starting.func_177230_c();
                                    return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString().equals(startBlock) && block.func_176201_c(starting) == startingMeta;
                                }
                            };
                            String endingBlock = blockInfoOfSegments[1];
                            final int endingMeta = metaInfoOfSegments[1];
                            if (endingBlock == null) {
                                change = endingMeta == -2 ? new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        return starting;
                                    }
                                } : (endingMeta == -1 ? new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        return starting.func_177230_c().func_176223_P();
                                    }
                                } : new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        return starting.func_177230_c().func_176203_a(endingMeta);
                                    }
                                });
                            } else {
                                final ResourceLocation endingBlockResourceLocation = new ResourceLocation(endingBlock);
                                change = endingMeta == -1 ? new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        return ((Block)Block.field_149771_c.func_82594_a((Object)endingBlockResourceLocation)).func_176223_P();
                                    }
                                } : (endingMeta == -2 ? new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        Block startBlock = starting.func_177230_c();
                                        return ((Block)Block.field_149771_c.func_82594_a((Object)endingBlockResourceLocation)).func_176203_a(startBlock.func_176201_c(starting));
                                    }
                                } : new BuildableBlockChanger.IChange(){

                                    @Override
                                    public IBlockState change(IBlockState starting) {
                                        return ((Block)Block.field_149771_c.func_82594_a((Object)endingBlockResourceLocation)).func_176203_a(endingMeta);
                                    }
                                });
                            }
                            changer.addChange(condition, change);
                            continue;
                        }
                        throw new Exception("Invalid number of block infomation segments");
                    }
                    String noTab = line.substring(1);
                    if (!noTab.trim().isEmpty()) {
                        biome = new ResourceLocation(noTab);
                    }
                    if (parsed.containsKey(biome)) {
                        changer = (BuildableBlockChanger)parsed.get(biome);
                        continue;
                    }
                    changer = new BuildableBlockChanger();
                    parsed.put(biome, changer);
                    continue;
                }
                String[] requires = line.substring(2).split(",");
                meetsRequirements = true;
                for (String each : requires) {
                    if (modNames.contains(each.trim().toLowerCase())) continue;
                    meetsRequirements = false;
                    continue block12;
                }
            }
            for (Map.Entry each : parsed.entrySet()) {
                MoVillagesBiomeManager.INSTANCE.addChanger((ResourceLocation)each.getKey(), (IBlockChanger)each.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

