/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.json.serapi;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.lib.zlib.error.Errors;
import com.zeitheron.hammercore.lib.zlib.error.JSONException;
import com.zeitheron.hammercore.lib.zlib.error.NoDefaultConstructorsExceptions;
import com.zeitheron.hammercore.lib.zlib.error.NoVariableFoundInJSONException;
import com.zeitheron.hammercore.lib.zlib.json.JSONArray;
import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import com.zeitheron.hammercore.lib.zlib.json.serapi.IgnoreSerialization;
import com.zeitheron.hammercore.lib.zlib.json.serapi.SerializationContext;
import com.zeitheron.hammercore.lib.zlib.json.serapi.SerializedName;
import com.zeitheron.hammercore.utils.ClassLoaderWrapper;
import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Jsonable {
    public static final ClassLoaderWrapper clsWrapper = new ClassLoaderWrapper(HammerCore.class.getClassLoader());

    default public SerializationContext serializationContext() {
        return null;
    }

    default public String serialize() {
        SerializationContext ctx = this.serializationContext();
        StringBuilder b = new StringBuilder();
        b.append("{");
        if (ctx != null) {
            for (Map.Entry entry : ctx.objects.entrySet()) {
                String name = Jsonable.formatInsideString((String)entry.getKey());
                Object val = entry.getValue();
                b.append("\"" + name + "\":");
                if (val instanceof CharSequence) {
                    b.append("\"" + Jsonable.formatInsideString(val + "") + "\"");
                } else if (val instanceof JSONObject) {
                    b.append(val.toString());
                } else if (val instanceof JSONArray) {
                    b.append(val.toString());
                } else if (val instanceof Jsonable) {
                    b.append(((Jsonable)val).serialize());
                } else if (val instanceof Iterable) {
                    try {
                        b.append(Jsonable.serializeIterable((Iterable)val));
                    }
                    catch (NotSerializableException e) {
                        Errors.propagate(e);
                    }
                } else {
                    b.append(val.toString());
                }
                b.append(",");
            }
        }
        for (Field f : this.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getAnnotation(IgnoreSerialization.class) != null || Modifier.isStatic(f.getModifiers())) continue;
            String name = f.getName();
            SerializedName aname = f.getAnnotation(SerializedName.class);
            if (aname != null) {
                name = aname.value();
            }
            name = Jsonable.formatInsideString(name);
            try {
                if (f.getType().isPrimitive() || CharSequence.class.isAssignableFrom(f.getType()) || Jsonable.class.isAssignableFrom(f.getType()) || Collection.class.isAssignableFrom(f.getType())) {
                    Object val = f.get(this);
                    String $ = Jsonable.formatInsideString(val + "");
                    if (val instanceof Jsonable) {
                        $ = ((Jsonable)val).serialize();
                    }
                    if (val instanceof CharSequence) {
                        $ = "\"" + Jsonable.formatInsideString(val + "") + "\"";
                    }
                    if (val instanceof Collection) {
                        $ = Jsonable.serializeIterable((Collection)val);
                    }
                    b.append("\"" + name + "\":" + $ + ",");
                    continue;
                }
                if (List.class.isAssignableFrom(f.getType())) {
                    b.append("\"" + name + "\":");
                    continue;
                }
                throw new NotSerializableException("Field " + f.getName() + " could not be serialized! Please insert @com.pengu.code.json.serapi.IgnoreSerialization !");
            }
            catch (Throwable err) {
                Errors.propagate(err);
            }
        }
        if (b.charAt(b.length() - 1) == ',') {
            b = b.deleteCharAt(b.length() - 1);
        }
        return b.append("}").toString();
    }

    public static String formatInsideString(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static <T extends Jsonable> T deserialize(String json, Class<T> type) throws JSONException {
        return (T)Jsonable.deserialize((JSONObject)new JSONTokener(json).nextValue(), type);
    }

    public static Object deserialize(String json) throws JSONException {
        Object o = new JSONTokener(json).nextValue();
        if (o instanceof JSONObject) {
            try {
                return Jsonable.deserialize((JSONObject)o);
            }
            catch (ClassNotFoundException e) {
                Errors.propagate(e);
            }
        } else {
            return Jsonable.deserialize((JSONArray)o);
        }
        return null;
    }

    public static <T extends Jsonable> T deserialize(String json, T type) throws JSONException {
        return Jsonable.deserialize((JSONObject)new JSONTokener(json).nextValue(), type);
    }

    public static String serializeStream(Stream<?> list) throws NotSerializableException {
        HashSet<NotSerializableException> err = new HashSet<NotSerializableException>();
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (Object js : list.collect(Collectors.toList())) {
            if (js instanceof Jsonable) {
                String l = ((Jsonable)js).serialize();
                s.append(l.substring(0, l.length() - 1) + ",\"__type\":\"" + clsWrapper.getName(js.getClass()) + "\"},");
                continue;
            }
            if (js instanceof Iterable) {
                s.append(Jsonable.serializeIterable((Iterable)js) + ",");
                continue;
            }
            err.add(new NotSerializableException(js.getClass().getName()));
        }
        if (!err.isEmpty()) {
            throw (NotSerializableException)err.stream().findFirst().get();
        }
        String ss = s.toString();
        if (ss.endsWith(",")) {
            ss = s.substring(0, s.length() - 1);
        }
        return ss + "]";
    }

    public static String serializeIterable(Iterable<?> list) throws NotSerializableException {
        HashSet<NotSerializableException> err = new HashSet<NotSerializableException>();
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (Object js : list) {
            if (js instanceof Jsonable) {
                String l = ((Jsonable)js).serialize();
                s.append(l.substring(0, l.length() - 1) + ",\"__type\":\"" + clsWrapper.getName(js.getClass()) + "\"},");
                continue;
            }
            if (js instanceof Iterable) {
                s.append(Jsonable.serializeIterable((Iterable)js) + ",");
                continue;
            }
            err.add(new NotSerializableException(js.getClass().getName()));
        }
        if (!err.isEmpty()) {
            throw (NotSerializableException)err.stream().findFirst().get();
        }
        String ss = s.toString();
        if (ss.endsWith(",")) {
            ss = s.substring(0, s.length() - 1);
        }
        return ss + "]";
    }

    public static <T extends Jsonable> T deserialize(JSONObject js, Class<T> type) throws JSONException {
        try {
            Constructor<T> constr = type.getConstructor(new Class[0]);
            constr.setAccessible(true);
            Jsonable i = null;
            try {
                i = (Jsonable)constr.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                Errors.propagate(e);
            }
            return (T)Jsonable.deserialize(js, i);
        }
        catch (NoSuchMethodException e) {
            throw new NoDefaultConstructorsExceptions(type, (Throwable)e);
        }
    }

    public static <T extends Jsonable> T deserialize(JSONObject js) throws JSONException, ClassNotFoundException {
        return (T)Jsonable.deserialize(js, clsWrapper.forName(js.getString("__type")));
    }

    default public void deserializeJson(JSONObject json) throws JSONException {
    }

    public static <T extends Jsonable> T deserialize(JSONObject js, T i) throws JSONException {
        try {
            i.deserializeJson(js);
            Class<?> type = i.getClass();
            for (Field f : type.getDeclaredFields()) {
                f.setAccessible(true);
                if (f.getAnnotation(IgnoreSerialization.class) != null || Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                SerializedName aname = f.getAnnotation(SerializedName.class);
                if (aname != null) {
                    name = aname.value();
                }
                if (!js.has(name)) {
                    throw new NoVariableFoundInJSONException("No key \"" + name + "\" found to be deserialized!");
                }
                Object obj = js.get(name);
                if (JSONObject.NULL.equals(obj)) {
                    f.set(i, null);
                    continue;
                }
                if (obj instanceof JSONObject && Jsonable.class.isAssignableFrom(f.getType())) {
                    Class<?> test = f.getType();
                    f.set(i, Jsonable.deserialize((JSONObject)obj, test));
                    continue;
                }
                if (obj instanceof JSONArray && Collection.class.isAssignableFrom(f.getType())) {
                    ArrayList<?> c = (ArrayList<?>)f.get(i);
                    if (c == null) {
                        c = List.class.isAssignableFrom(f.getType()) ? new ArrayList() : new HashSet();
                        f.set(i, c);
                    }
                    c.clear();
                    c.addAll(Jsonable.deserialize((JSONArray)obj));
                    continue;
                }
                f.set(i, obj);
            }
            return i;
        }
        catch (IllegalAccessException e) {
            Errors.propagate(e);
            return null;
        }
    }

    public static List<?> deserialize(JSONArray js) throws JSONException {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (int i = 0; i < js.length(); ++i) {
            Object obj = js.get(i);
            if (obj instanceof JSONArray) {
                data.add(Jsonable.deserialize((JSONArray)obj));
                continue;
            }
            if (!(obj instanceof JSONObject)) continue;
            try {
                data.add((List<Object>)Jsonable.deserialize((JSONObject)obj));
                continue;
            }
            catch (ClassNotFoundException e) {
                Errors.propagate(e);
            }
        }
        return data;
    }
}

