/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

public class FrictionRotator {
    public float degree;
    public float prevDegree;
    public float friction = 1.0f;
    public float currentSpeed;
    public float speed;

    public void speedup(float speed) {
        this.speed += speed;
    }

    public void slowdown(float speed) {
        this.speed -= speed;
    }

    public float getActualRotation(float partialTime) {
        return (this.prevDegree + (this.degree - this.prevDegree) * partialTime) % 360.0f;
    }

    public void update() {
        if (Float.isNaN(this.speed)) {
            this.speed = 0.0f;
        }
        if (Float.isNaN(this.currentSpeed)) {
            this.currentSpeed = 0.0f;
        }
        if (this.currentSpeed > this.speed) {
            this.currentSpeed = (float)((double)this.currentSpeed - Math.sqrt(this.currentSpeed - this.speed));
        } else if (this.speed > this.currentSpeed) {
            this.currentSpeed = (float)((double)this.currentSpeed + Math.sqrt(this.speed - this.currentSpeed));
        }
        if (Math.abs(this.currentSpeed) - this.friction <= 0.004f) {
            this.currentSpeed = 0.0f;
        }
        this.prevDegree = this.degree;
        this.degree += this.currentSpeed;
        float frictionBoost = (float)Math.sqrt(Math.sqrt(Math.abs(this.speed)));
        if (this.speed > 0.0f) {
            this.speed = Math.max(0.0f, this.speed - this.friction * frictionBoost);
        } else if (this.speed < 0.0f) {
            this.speed = Math.min(0.0f, this.speed + this.friction * frictionBoost);
        }
    }
}

