/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.Preference;
import waterpower.annotations.Init;
import waterpower.common.block.BlockEnum;
import waterpower.common.block.ore.Ores;
import waterpower.common.init.WPBlocks;
import waterpower.config.OreConfig;

@Init
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016JN\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0015J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0007J\b\u0010#\u001a\u00020\u0011H\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lwaterpower/common/WorldGen;", "Lnet/minecraft/world/gen/feature/WorldGenerator;", "()V", "pos", "Lnet/minecraft/util/math/BlockPos;", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "setPos", "(Lnet/minecraft/util/math/BlockPos;)V", "generate", "", "world", "Lnet/minecraft/world/World;", "random", "Ljava/util/Random;", "position", "generateOre", "", "ore", "Lnet/minecraft/item/ItemStack;", "number", "", "amountPerChunk", "chunkX", "chunkZ", "minLevel", "maxLevel", "oreConfig", "Lwaterpower/config/OreConfig;", "minable", "Lnet/minecraft/world/gen/feature/WorldGenMinable;", "num", "onOreGen", "event", "Lnet/minecraftforge/event/terraingen/OreGenEvent$Post;", "preInit", "WaterPower_main"})
public final class WorldGen
extends WorldGenerator {
    @Nullable
    private static BlockPos pos;
    public static final WorldGen INSTANCE;

    @NotNull
    public final WorldGenMinable minable(@NotNull ItemStack ore, int num) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        IBlockState blockState = Block.func_149634_a((Item)ore.func_77973_b()).func_176203_a(ore.func_77960_j());
        return new WorldGenMinable(blockState, num);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateOre(@NotNull ItemStack ore, int number, int amountPerChunk, @NotNull World world, @NotNull Random random, int chunkX, int chunkZ, int minLevel, int maxLevel) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        long count = Math.round((random.nextGaussian() / (double)2 + 0.5) * (double)amountPerChunk);
        long l = 1;
        long l2 = count;
        if (l <= l2) {
            while (true) {
                void n;
                int x = chunkX * 16 + random.nextInt(16);
                int y = random.nextInt(maxLevel - minLevel) + minLevel;
                int z = chunkZ * 16 + random.nextInt(16);
                this.minable(ore, number).func_180709_b(world, random, new BlockPos(x, y, z));
                if (n == l2) break;
                ++n;
            }
        }
    }

    public final void generateOre(@NotNull ItemStack ore, @NotNull OreConfig oreConfig, @NotNull World world, @NotNull Random random, int chunkX, int chunkZ) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        Intrinsics.checkParameterIsNotNull((Object)oreConfig, (String)"oreConfig");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        this.generateOre(ore, oreConfig.getMaxSize(), oreConfig.getAmountPerChunk(), world, random, chunkX, chunkZ, oreConfig.getMinLevel(), oreConfig.getMaxLevel());
    }

    public boolean func_180709_b(@NotNull World world, @NotNull Random random, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (!TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this, (BlockPos)position, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            return true;
        }
        int chunkX = position.func_177958_n() / 16;
        int chunkZ = position.func_177952_p() / 16;
        this.generateOre(BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), Ores.Vanadium, 0, 2, null), Preference.OreGeneration.INSTANCE.getVanadiumOre(), world, random, chunkX, chunkZ);
        this.generateOre(BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), Ores.Manganese, 0, 2, null), Preference.OreGeneration.INSTANCE.getManganeseOre(), world, random, chunkX, chunkZ);
        this.generateOre(BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), Ores.Monazite, 0, 2, null), Preference.OreGeneration.INSTANCE.getMonaziteOre(), world, random, chunkX, chunkZ);
        this.generateOre(BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), Ores.Magnetite, 0, 2, null), Preference.OreGeneration.INSTANCE.getMagnetiteOre(), world, random, chunkX, chunkZ);
        this.generateOre(BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), Ores.Zinc, 0, 2, null), Preference.OreGeneration.INSTANCE.getZincOre(), world, random, chunkX, chunkZ);
        return true;
    }

    @JvmStatic
    public static final void preInit() {
        MinecraftForge.ORE_GEN_BUS.register((Object)INSTANCE);
    }

    @Nullable
    public final BlockPos getPos() {
        return pos;
    }

    public final void setPos(@Nullable BlockPos blockPos) {
        pos = blockPos;
    }

    @SubscribeEvent
    public final void onOreGen(@NotNull OreGenEvent.Post event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getPos(), (Object)pos)) {
            return;
        }
        pos = event.getPos();
        World world = event.getWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
        Random random = event.getRand();
        Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"event.rand");
        BlockPos blockPos = event.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"event.pos");
        this.func_180709_b(world, random, blockPos);
    }

    private WorldGen() {
        super(false);
        INSTANCE = this;
    }

    static {
        new WorldGen();
    }
}

