/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.attachment;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import ic2.api.recipe.ILiquidAcceptManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.inventory.InventorySlot;
import waterpower.common.block.tile.TileEntityBase;
import waterpower.util.INBTSerializable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002>?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J@\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010 \u001a\u00020!2\u0014\u0010\"\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000bJ\u0014\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0007J*\u0010%\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\fJ\u001e\u0010%\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010'\u001a\u00020(J%\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150*\"\u00020\u0015\u00a2\u0006\u0002\u0010+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-J<\u0010.\u001a,\u0012(\u0012&\u0012\f\u0012\n 2*\u0004\u0018\u00010101 2*\u0012\u0012\f\u0012\n 2*\u0004\u0018\u00010101\u0018\u000100000/2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0016J-\u00103\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H4002\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u0002082\u0006\u0010\u000f\u001a\u00020\u0010J\b\u00109\u001a\u00020\u0010H\u0016J\u0010\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000b0\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006@"}, d2={"Lwaterpower/common/block/attachment/AttachmentFluid;", "Lwaterpower/common/block/attachment/TileEntityAttachment;", "base", "Lwaterpower/common/block/tile/TileEntityBase;", "(Lwaterpower/common/block/tile/TileEntityBase;)V", "managedTanks", "", "Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "getManagedTanks", "()Ljava/util/List;", "unmanagedTanks", "Lcom/google/common/base/Supplier;", "", "getUnmanagedTanks", "addTank", "name", "", "capacity", "", "acceptedFluids", "Lcom/google/common/base/Predicate;", "Lnet/minecraftforge/fluids/Fluid;", "inputSides", "Lnet/minecraft/util/EnumFacing;", "outputSides", "access", "Lwaterpower/common/block/inventory/InventorySlot$Access;", "side", "Lwaterpower/common/block/inventory/InventorySlot$InvSide;", "tank", "addTankExtract", "addTankInsert", "addUnmanagedTankHook", "", "suppl", "addUnmanagedTanks", "tanks", "changeConnectivity", "fluidPredicate", "manager", "Lic2/api/recipe/ILiquidAcceptManager;", "fluids", "", "([Lnet/minecraftforge/fluids/Fluid;)Lcom/google/common/base/Predicate;", "getAllTanks", "", "getCapabilities", "", "Lnet/minecraftforge/common/capabilities/Capability;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "kotlin.jvm.PlatformType", "getCapability", "T", "capability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getFluidTank", "Lnet/minecraftforge/fluids/FluidTank;", "getName", "readFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "FluidHandler", "FluidTankImpl", "WaterPower_main"})
public final class AttachmentFluid
extends TileEntityAttachment {
    @NotNull
    private final List<FluidTankImpl> managedTanks;
    @NotNull
    private final List<Supplier<? extends Collection<FluidTankImpl>>> unmanagedTanks;

    @NotNull
    protected final List<FluidTankImpl> getManagedTanks() {
        return this.managedTanks;
    }

    @NotNull
    protected final List<Supplier<? extends Collection<FluidTankImpl>>> getUnmanagedTanks() {
        return this.unmanagedTanks;
    }

    @Override
    @NotNull
    public String getName() {
        return "fluid";
    }

    @NotNull
    public final FluidTankImpl addTankInsert(@NotNull String name, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Predicate predicate = Predicates.alwaysTrue();
        Intrinsics.checkExpressionValueIsNotNull((Object)predicate, (String)"Predicates.alwaysTrue<Fluid>()");
        return this.addTankInsert(name, capacity, (Predicate<Fluid>)predicate);
    }

    @NotNull
    public final FluidTankImpl addTankInsert(@NotNull String name, int capacity, @NotNull Predicate<Fluid> acceptedFluids) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(acceptedFluids, (String)"acceptedFluids");
        return this.addTankInsert(name, capacity, InventorySlot.InvSide.ANY, acceptedFluids);
    }

    @NotNull
    public final FluidTankImpl addTankInsert(@NotNull String name, int capacity, @NotNull InventorySlot.InvSide side) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        Predicate predicate = Predicates.alwaysTrue();
        Intrinsics.checkExpressionValueIsNotNull((Object)predicate, (String)"Predicates.alwaysTrue<Fluid>()");
        return this.addTankInsert(name, capacity, side, (Predicate<Fluid>)predicate);
    }

    @NotNull
    public final FluidTankImpl addTankInsert(@NotNull String name, int capacity, @NotNull InventorySlot.InvSide side, @NotNull Predicate<Fluid> acceptedFluids) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        Intrinsics.checkParameterIsNotNull(acceptedFluids, (String)"acceptedFluids");
        return this.addTank(name, capacity, InventorySlot.Access.I, side, acceptedFluids);
    }

    @NotNull
    public final FluidTankImpl addTankExtract(@NotNull String name, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.addTankExtract(name, capacity, InventorySlot.InvSide.ANY);
    }

    @NotNull
    public final FluidTankImpl addTankExtract(@NotNull String name, int capacity, @NotNull InventorySlot.InvSide side) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        return this.addTank(name, capacity, InventorySlot.Access.O, side);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.addTank(name, capacity, InventorySlot.Access.IO);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity, @NotNull InventorySlot.Access access) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        return this.addTank(name, capacity, access, InventorySlot.InvSide.ANY);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity, @NotNull Predicate<Fluid> acceptedFluids) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(acceptedFluids, (String)"acceptedFluids");
        return this.addTank(name, capacity, InventorySlot.Access.IO, InventorySlot.InvSide.ANY, acceptedFluids);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity, @NotNull InventorySlot.Access access, @NotNull InventorySlot.InvSide side) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        Predicate predicate = Predicates.alwaysTrue();
        Intrinsics.checkExpressionValueIsNotNull((Object)predicate, (String)"Predicates.alwaysTrue()");
        return this.addTank(name, capacity, access, side, (Predicate<Fluid>)predicate);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity, @NotNull InventorySlot.Access access, @NotNull InventorySlot.InvSide side, @NotNull Predicate<Fluid> acceptedFluids) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        Intrinsics.checkParameterIsNotNull(acceptedFluids, (String)"acceptedFluids");
        return this.addTank(name, capacity, (Collection<? extends EnumFacing>)(access.isInput() ? side.getAcceptedSides() : SetsKt.emptySet()), (Collection<? extends EnumFacing>)(access.isOutput() ? side.getAcceptedSides() : SetsKt.emptySet()), acceptedFluids);
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull String name, int capacity, @NotNull Collection<? extends EnumFacing> inputSides, @NotNull Collection<? extends EnumFacing> outputSides, @NotNull Predicate<Fluid> acceptedFluids) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(inputSides, (String)"inputSides");
        Intrinsics.checkParameterIsNotNull(outputSides, (String)"outputSides");
        Intrinsics.checkParameterIsNotNull(acceptedFluids, (String)"acceptedFluids");
        return this.addTank(new FluidTankImpl(name, inputSides, outputSides, acceptedFluids, capacity));
    }

    @NotNull
    public final FluidTankImpl addTank(@NotNull FluidTankImpl tank) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        this.managedTanks.add(tank);
        return tank;
    }

    public final void addUnmanagedTanks(@NotNull FluidTankImpl tank) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        Supplier supplier = Suppliers.ofInstance((Object)SetsKt.setOf((Object)tank));
        Intrinsics.checkExpressionValueIsNotNull((Object)supplier, (String)"Suppliers.ofInstance<Set\u2026tOf<FluidTankImpl>(tank))");
        this.unmanagedTanks.add((Supplier<? extends Collection<FluidTankImpl>>)supplier);
    }

    public final void addUnmanagedTanks(@NotNull Collection<FluidTankImpl> tanks) {
        Intrinsics.checkParameterIsNotNull(tanks, (String)"tanks");
        Supplier supplier = Suppliers.ofInstance(tanks);
        Intrinsics.checkExpressionValueIsNotNull((Object)supplier, (String)"Suppliers.ofInstance<Col\u2026on<FluidTankImpl>>(tanks)");
        this.addUnmanagedTankHook((Supplier<? extends Collection<FluidTankImpl>>)supplier);
    }

    public final void addUnmanagedTankHook(@NotNull Supplier<? extends Collection<FluidTankImpl>> suppl) {
        Intrinsics.checkParameterIsNotNull(suppl, (String)"suppl");
        this.unmanagedTanks.add(suppl);
    }

    public final void changeConnectivity(@NotNull FluidTankImpl tank, @NotNull InventorySlot.Access access, @NotNull InventorySlot.InvSide side) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        this.changeConnectivity(tank, (Collection<? extends EnumFacing>)(access.isInput() ? side.getAcceptedSides() : SetsKt.emptySet()), (Collection<? extends EnumFacing>)(access.isOutput() ? side.getAcceptedSides() : SetsKt.emptySet()));
    }

    public final void changeConnectivity(@NotNull FluidTankImpl tank, @NotNull Collection<? extends EnumFacing> inputSides, @NotNull Collection<? extends EnumFacing> outputSides) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        Intrinsics.checkParameterIsNotNull(inputSides, (String)"inputSides");
        Intrinsics.checkParameterIsNotNull(outputSides, (String)"outputSides");
        tank.setInputSides(inputSides);
        tank.setOutputSides(outputSides);
    }

    @NotNull
    public final FluidTank getFluidTank(@NotNull String name) {
        FluidTankImpl tank;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Iterator<FluidTankImpl> var2 = this.getAllTanks().iterator();
        do {
            if (var2.hasNext()) continue;
            throw (Throwable)new IllegalArgumentException("Unable to find tank: " + name);
        } while (Intrinsics.areEqual((Object)(tank = var2.next()).getId(), (Object)name) ^ true);
        return tank;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        for (FluidTankImpl tank : this.managedTanks) {
            if (!tag.func_150297_b(tank.getId(), 10)) continue;
            tank.readFromNBT(tag.func_74775_l(tank.getId()));
        }
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (FluidTankImpl tank : this.managedTanks) {
            NBTTagCompound subTag = new NBTTagCompound();
            NBTTagCompound nBTTagCompound = tank.writeToNBT(subTag);
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"tank.writeToNBT(subTag)");
            subTag = nBTTagCompound;
            nbt.func_74782_a(tank.getId(), (NBTBase)subTag);
        }
        return nbt;
    }

    @NotNull
    public Set<Capability<IFluidHandler>> getCapabilities(@Nullable EnumFacing side) {
        return SetsKt.setOf((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return (T)(Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) ? (Object)new FluidHandler(side) : super.getCapability(capability, side));
    }

    @NotNull
    public final Predicate<Fluid> fluidPredicate(Fluid ... fluids) {
        Collection<Object> acceptedFluids;
        Intrinsics.checkParameterIsNotNull((Object)fluids, (String)"fluids");
        if (((Object[])fluids).length > 10) {
            acceptedFluids = new HashSet(Arrays.asList(Arrays.copyOf(fluids, fluids.length)));
        } else {
            List<Fluid> list = Arrays.asList(Arrays.copyOf(fluids, fluids.length));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*fluids)");
            acceptedFluids = list;
        }
        return (Predicate)new Predicate<Fluid>(acceptedFluids){
            final /* synthetic */ Object $acceptedFluids;

            public final boolean apply(@Nullable Fluid fluid) {
                Object object = this.$acceptedFluids;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<*>");
                }
                return ((Collection)object).contains(fluid);
            }
            {
                this.$acceptedFluids = object;
            }
        };
    }

    @NotNull
    public final Predicate<Fluid> fluidPredicate(@NotNull ILiquidAcceptManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        return (Predicate)new Predicate<Fluid>(manager){
            final /* synthetic */ ILiquidAcceptManager $manager;

            public final boolean apply(@Nullable Fluid fluid) {
                return this.$manager.acceptsFluid(fluid);
            }
            {
                this.$manager = iLiquidAcceptManager;
            }
        };
    }

    @NotNull
    public final Iterable<FluidTankImpl> getAllTanks() {
        if (this.unmanagedTanks.isEmpty()) {
            return this.managedTanks;
        }
        ArrayList tanks = new ArrayList();
        tanks.addAll(this.managedTanks);
        Iterator<Supplier<? extends Collection<FluidTankImpl>>> var2 = this.unmanagedTanks.iterator();
        while (var2.hasNext()) {
            Object object = var2.next().get();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<waterpower.common.block.attachment.AttachmentFluid.FluidTankImpl>");
            }
            tanks.addAll((Collection)object);
        }
        return tanks;
    }

    public AttachmentFluid(@NotNull TileEntityBase base) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)base), (String)"base");
        super(base);
        this.managedTanks = new ArrayList();
        this.unmanagedTanks = new ArrayList();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\nH\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lwaterpower/common/block/attachment/AttachmentFluid$FluidHandler;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lwaterpower/common/block/attachment/AttachmentFluid;Lnet/minecraft/util/EnumFacing;)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "", "doDrain", "", "resource", "fill", "doFill", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "WaterPower_main"})
    private final class FluidHandler
    implements IFluidHandler {
        private final EnumFacing side;

        @NotNull
        public IFluidTankProperties[] getTankProperties() {
            ArrayList<IFluidTankProperties> props = new ArrayList<IFluidTankProperties>(AttachmentFluid.this.getManagedTanks().size());
            Iterator<FluidTankImpl> var2 = AttachmentFluid.this.getAllTanks().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    Collection $receiver$iv;
                    Collection thisCollection$iv = $receiver$iv = (Collection)props;
                    IFluidTankProperties[] iFluidTankPropertiesArray = thisCollection$iv.toArray(new IFluidTankProperties[thisCollection$iv.size()]);
                    if (iFluidTankPropertiesArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    return iFluidTankPropertiesArray;
                }
                FluidTankImpl tank = var2.next();
                if (!tank.canFill(this.side) && !tank.canDrain(this.side)) continue;
                props.add(tank.getTankProperties$WaterPower_main(this.side));
            }
        }

        public int fill(@Nullable FluidStack resource, boolean doFill) {
            if (resource != null && resource.amount > 0) {
                int total = 0;
                FluidStack missing = resource.copy();
                for (FluidTankImpl tank : AttachmentFluid.this.getAllTanks()) {
                    if (!tank.canFill(this.side)) continue;
                    missing.amount = resource.amount - (total += tank.fill(missing, doFill));
                    if (missing.amount > 0) continue;
                    break;
                }
                return total;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
            if (resource != null && resource.amount > 0) {
                FluidStack ret = new FluidStack(resource.getFluid(), 0);
                for (FluidTankImpl tank : AttachmentFluid.this.getAllTanks()) {
                    FluidStack add;
                    FluidStack inTank;
                    if (!tank.canDrain(this.side) || (inTank = tank.getFluid()) == null || !Intrinsics.areEqual((Object)inTank.getFluid(), (Object)resource.getFluid()) || (add = tank.drain(resource.amount - ret.amount, doDrain)) == null) continue;
                    boolean bl = Intrinsics.areEqual((Object)add.getFluid(), (Object)resource.getFluid());
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    ret.amount += add.amount;
                    if (ret.amount < resource.amount) continue;
                    break;
                }
                return ret.amount == 0 ? null : ret;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            for (FluidTankImpl tank : AttachmentFluid.this.getAllTanks()) {
                FluidStack stack;
                if (!tank.canDrain(this.side) || (stack = tank.drain(maxDrain, false)) == null) continue;
                stack.amount = maxDrain;
                return this.drain(stack, doDrain);
            }
            return null;
        }

        public FluidHandler(EnumFacing side) {
            this.side = side;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0013\u0010)\u001a\u00020\u001a2\b\u0010*\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010+\u001a\u0004\u0018\u00010\u0004J\u0017\u0010,\u001a\u00020-2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020(H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016\u00a8\u00060"}, d2={"Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "Lnet/minecraftforge/fluids/FluidTank;", "Lwaterpower/util/INBTSerializable;", "id", "", "inputSides", "", "Lnet/minecraft/util/EnumFacing;", "outputSides", "acceptsFluidPredicate", "Lcom/google/common/base/Predicate;", "Lnet/minecraftforge/fluids/Fluid;", "capacity", "", "(Ljava/lang/String;Ljava/util/Collection;Ljava/util/Collection;Lcom/google/common/base/Predicate;I)V", "getAcceptsFluidPredicate", "()Lcom/google/common/base/Predicate;", "getId", "()Ljava/lang/String;", "getInputSides", "()Ljava/util/Collection;", "setInputSides", "(Ljava/util/Collection;)V", "getOutputSides", "setOutputSides", "acceptsFluid", "", "fluid", "canDrain", "side", "canDrainFluidType", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "canFill", "canFillFluidType", "clone", "", "deserializeNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "equals", "other", "getFluidName", "getTankProperties", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "getTankProperties$WaterPower_main", "serializeNBT", "WaterPower_main"})
    public static final class FluidTankImpl
    extends FluidTank
    implements INBTSerializable<FluidTankImpl> {
        @NotNull
        private final String id;
        @NotNull
        private Collection<? extends EnumFacing> inputSides;
        @NotNull
        private Collection<? extends EnumFacing> outputSides;
        @NotNull
        private final Predicate<Fluid> acceptsFluidPredicate;

        public boolean canFillFluidType(@Nullable FluidStack fluidStack) {
            return fluidStack != null && this.acceptsFluidPredicate.apply((Object)fluidStack.getFluid());
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluidStack) {
            return fluidStack != null && this.acceptsFluidPredicate.apply((Object)fluidStack.getFluid());
        }

        public final boolean acceptsFluid(@NotNull Fluid fluid) {
            Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
            return this.acceptsFluidPredicate.apply((Object)fluid);
        }

        @NotNull
        public final IFluidTankProperties getTankProperties$WaterPower_main(@Nullable EnumFacing side) {
            return new IFluidTankProperties(this, side){
                final /* synthetic */ FluidTankImpl this$0;
                final /* synthetic */ EnumFacing $side;

                @Nullable
                public FluidStack getContents() {
                    return this.this$0.getFluid();
                }

                public int getCapacity() {
                    return FluidTankImpl.access$getCapacity$p(this.this$0);
                }

                public boolean canFill() {
                    return this.this$0.canFill(this.$side);
                }

                public boolean canDrain() {
                    return this.this$0.canDrain(this.$side);
                }

                public boolean canFillFluidType(@Nullable FluidStack fluidStack) {
                    boolean bl;
                    if (fluidStack != null && fluidStack.amount > 0) {
                        Fluid fluid = fluidStack.getFluid();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"fluidStack.fluid");
                        bl = this.this$0.acceptsFluid(fluid) && (this.$side == null || this.this$0.canFill(this.$side));
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public boolean canDrainFluidType(@Nullable FluidStack fluidStack) {
                    boolean bl;
                    if (fluidStack != null && fluidStack.amount > 0) {
                        Fluid fluid = fluidStack.getFluid();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"fluidStack.fluid");
                        bl = this.this$0.acceptsFluid(fluid) && (this.$side == null || this.this$0.canDrain(this.$side));
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.this$0 = $outer;
                    this.$side = $captured_local_variable$1;
                }
            };
        }

        public final boolean canFill(@Nullable EnumFacing side) {
            return CollectionsKt.contains((Iterable)this.inputSides, (Object)side);
        }

        public final boolean canDrain(@Nullable EnumFacing side) {
            return CollectionsKt.contains((Iterable)this.outputSides, (Object)side);
        }

        @Nullable
        public final String getFluidName() {
            FluidStack fluidStack = this.fluid;
            return fluidStack != null && (fluidStack = fluidStack.getFluid()) != null ? fluidStack.getName() : null;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof FluidTank) {
                return this.getFluidAmount() == ((FluidTank)other).getFluidAmount() && Intrinsics.areEqual((Object)this.fluid, (Object)((FluidTank)other).getFluid()) && this.capacity == ((FluidTank)other).getCapacity();
            }
            return false;
        }

        @Override
        @NotNull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            tag.func_74768_a("capacity", this.capacity);
            return tag;
        }

        @Override
        public void deserializeNBT(@NotNull NBTTagCompound tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.readFromNBT(tag);
            this.capacity = tag.func_74762_e("capacity");
        }

        @Override
        @NotNull
        public Object clone() {
            FluidTankImpl f = new FluidTankImpl(this.id, this.inputSides, this.outputSides, this.acceptsFluidPredicate, 0);
            f.deserializeNBT(this.serializeNBT());
            return f;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Collection<EnumFacing> getInputSides() {
            return this.inputSides;
        }

        public final void setInputSides(@NotNull Collection<? extends EnumFacing> collection) {
            Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
            this.inputSides = collection;
        }

        @NotNull
        public final Collection<EnumFacing> getOutputSides() {
            return this.outputSides;
        }

        public final void setOutputSides(@NotNull Collection<? extends EnumFacing> collection) {
            Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
            this.outputSides = collection;
        }

        @NotNull
        public final Predicate<Fluid> getAcceptsFluidPredicate() {
            return this.acceptsFluidPredicate;
        }

        public FluidTankImpl(@NotNull String id, @NotNull Collection<? extends EnumFacing> inputSides, @NotNull Collection<? extends EnumFacing> outputSides, @NotNull Predicate<Fluid> acceptsFluidPredicate, int capacity) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(inputSides, (String)"inputSides");
            Intrinsics.checkParameterIsNotNull(outputSides, (String)"outputSides");
            Intrinsics.checkParameterIsNotNull(acceptsFluidPredicate, (String)"acceptsFluidPredicate");
            super(capacity);
            this.id = id;
            this.inputSides = inputSides;
            this.outputSides = outputSides;
            this.acceptsFluidPredicate = acceptsFluidPredicate;
        }

        public static final /* synthetic */ int access$getCapacity$p(FluidTankImpl $this) {
            return $this.capacity;
        }

        public static final /* synthetic */ void access$setCapacity$p(FluidTankImpl $this, int n) {
            $this.capacity = n;
        }
    }
}

