/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.attachment;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.Energy;
import waterpower.common.block.attachment.AttachmentMJ;
import waterpower.common.block.attachment.EnergyStorage;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.tile.TileEntityBase;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\u0017\u0010\u001b\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0014\u0010 \u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lwaterpower/common/block/attachment/AttachmentMJ;", "Lwaterpower/common/block/attachment/TileEntityAttachment;", "master", "Lwaterpower/common/block/tile/TileEntityBase;", "energyStorage", "Lwaterpower/common/block/attachment/EnergyStorage;", "(Lwaterpower/common/block/tile/TileEntityBase;Lwaterpower/common/block/attachment/EnergyStorage;)V", "getEnergyStorage", "()Lwaterpower/common/block/attachment/EnergyStorage;", "mjConnector", "", "getMjConnector", "()Ljava/lang/Object;", "setMjConnector", "(Ljava/lang/Object;)V", "getName", "", "getPowerToExtract", "", "facing", "Lnet/minecraft/util/EnumFacing;", "doExtract", "", "getReceiverToPower", "tile", "Lnet/minecraft/tileentity/TileEntity;", "side", "getTileBuffer", "Ljavax/annotation/Nullable;", "onLoaded", "", "onTick", "runIgnoringThrowables", "x", "Lkotlin/Function0;", "sendPower", "WaterPower_main"})
public final class AttachmentMJ
extends TileEntityAttachment {
    @NotNull
    public Object mjConnector;
    @NotNull
    private final EnergyStorage energyStorage;

    @Override
    @NotNull
    public String getName() {
        return "mj";
    }

    @NotNull
    public final Object getMjConnector() {
        Object object = this.mjConnector;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mjConnector");
        }
        return object;
    }

    public final void setMjConnector(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
        this.mjConnector = object;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.runIgnoringThrowables((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AttachmentMJ this$0;

            public final void invoke() {
                this.this$0.setMjConnector(onLoaded.1.INSTANCE);
            }
            {
                this.this$0 = attachmentMJ;
                super(0);
            }
        }));
    }

    @Override
    public void onTick() {
        super.onTick();
        this.runIgnoringThrowables((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AttachmentMJ this$0;

            public final void invoke() {
                EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                for (int i = 0; i < enumFacingArray.length; ++i) {
                    EnumFacing facing;
                    EnumFacing enumFacing = facing = enumFacingArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
                    AttachmentMJ.access$sendPower(this.this$0, enumFacing);
                }
            }
            {
                this.this$0 = attachmentMJ;
                super(0);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object getReceiverToPower(@Nullable TileEntity tile, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (tile == null) {
            return null;
        }
        IMjReceiver rec = (IMjReceiver)tile.getCapability(MjAPI.CAP_RECEIVER, side.func_176734_d());
        if (rec == null) return null;
        Object object = this.mjConnector;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mjConnector");
        }
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type buildcraft.api.mj.IMjConnector");
        }
        if (!rec.canConnect((IMjConnector)object)) return null;
        IMjReceiver iMjReceiver = rec;
        return iMjReceiver;
    }

    private final TileEntity getTileBuffer(EnumFacing facing) {
        return this.getMaster().func_145831_w().func_175625_s(this.getMaster().func_174877_v().func_177972_a(facing));
    }

    private final long getPowerToExtract(EnumFacing facing, boolean doExtract) {
        TileEntity tile = this.getTileBuffer(facing);
        if (tile == null) {
            return 0L;
        }
        Object receiver = this.getReceiverToPower(tile, facing);
        return receiver == null ? 0L : (long)this.energyStorage.extractEnergy(Energy.Companion.MJ2EU(((IMjReceiver)receiver).getPowerRequested()), doExtract);
    }

    private final void sendPower(EnumFacing facing) {
        long extracted;
        Object receiver;
        TileEntity tile = this.getTileBuffer(facing);
        if (tile != null && (receiver = this.getReceiverToPower(tile, facing)) != null && (extracted = this.getPowerToExtract(facing, true)) > 0L && receiver instanceof IMjReceiver) {
            long excess = ((IMjReceiver)receiver).receivePower(extracted, false);
            this.energyStorage.extractEnergy(Energy.Companion.MJ2EU(extracted - excess), true);
        }
    }

    public final void runIgnoringThrowables(@NotNull Function0<Unit> x) {
        Intrinsics.checkParameterIsNotNull(x, (String)"x");
        try {
            x.invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public final EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public AttachmentMJ(@NotNull TileEntityBase master, @NotNull EnergyStorage energyStorage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)master), (String)"master");
        Intrinsics.checkParameterIsNotNull((Object)energyStorage, (String)"energyStorage");
        super(master);
        this.energyStorage = energyStorage;
    }

    public static final /* synthetic */ void access$sendPower(AttachmentMJ $this, @NotNull EnumFacing facing) {
        $this.sendPower(facing);
    }
}

